# coding=utf-8
from __future__ import unicode_literals, absolute_import
from ..utils.enum import Enum, unique


@unique
class KEFU_STATUS(Enum):
    OFFLINE = (0, '离线')
    ONLINE = (1, '在线')
    LEAVE = (2, '离开')


@unique
class THREAD_SOURCE(Enum):
    NEW = (1, '新创建')
    TRANSFER = (2, '转接')


@unique
class THREAD_RESULT(Enum):
    STAFF_FINISH = (0, '客服完成')
    USER_TIMEOUT = (1, '用户超时')
    STAFF_TIMEOUT = (2, '客服超时')
    TRANSFER = (3, '转接')
    STAFF_TRANSFER_GROUP = (4, '客服转接分组')
    USER_TRANSFER = (5, '用户重新选择分组')


@unique
class THREAD_STATUS(Enum):
    FINISHED = (0, '服务完成')
    SERVING = (1, '服务中')


@unique
class TICKET_RESULT(Enum):
    STAFF_FINISH = (0, '客服完成')
    USER_TIMEOUT = (1, '用户超时')
    STAFF_TIMEOUT = (2, '客服超时')
    STAFF_TRANSFER_GROUP = (4, '客服转接分组')
    USER_TRANSFER = (5, '用户重新选择分组')


@unique
class MESSAGE_TYPE(Enum):
    CONTENT = (0, '对话消息')
    CONTROL = (1, '控制消息')


@unique
class MESSAGE_ROLE(Enum):
    STAFF = (1, '客服')
    USER = (2, '用户')


@unique
class POLL_EVENT_TYPE(Enum):
    MESSAGE = (1, '消息')
    USER = (2, '用户')


@unique
class CONVERSATION_STATUS(Enum):
    FINISH = (0, '已结束')
    IN_QUEUE = (1, '排队中')
    PROCESSING = (2, '进行中')


@unique
class WEBSOCKET_TYPE(Enum):
    NEW_MESSAGE = (1, '新消息')
    NEW_USER = (2, '新用户')
    CONTROL = (3, '控制消息')
    NEW_COMMENT = (4, '新留言')


@unique
class PUSH_CODE(Enum):
    START = (1, '开始会话')
    FINISH = (2, '客服完成会话')
    TIMEOUT = (3, '超时提示')
    USER_OFFLINE = (4, '用户超时下线')
    WAIT_OFFLINE = (5, '排队超时下线')
    SYS_MSG = (6, '下发系统消息')


@unique
class KEFU_RESPONSE(Enum):
    WAITING = (1, '排队提示')
    KEFU_ACCESS = (2, '客服接入')
    WAITING_TIMEOUT = (3, '排队超时')
    WELCOME = (4, '客服欢迎语')
    USER_TIMEOUT = (5, '用户超时提示')
    KEFU_TIMEOUT = (6, '客服超时提示')
    TIMEOUT_OFFLINE = (7, '用户超时下线')
    KEFU_FINISH = (8, '客服标记会话结束')
    MESSAGE_RECEIVED = (9, '客服收到留言')
    NO_KEFU = (10, '客服离线回复')
    TRANSFER = (11, '转接提示语')
    CHANGE_ENTRY = (12, '用户主动切换组')


@unique
class ALERT_TYPE(Enum):
    ALERT = (1, '系统提示')
    CONVERSATION = (2, '对话消息')
