# coding=utf-8
import os
import unittest

from django.conf import settings

from gm_upload import (
    upload, upload_with_short, get_private_url, get_private_url_for_long,
    IMG_TYPE, ImgUrlField,
)

def init_django_conf():
    if not settings.configured:
        settings.configure(
            QINIU_ACCESS_KEY=os.environ.get('QINIU_ACCESS_KEY'),
            QINIU_SECRET_KEY=os.environ.get('QINIU_SECRET_KEY'),
        )

init_django_conf()

class DjangoTestBase(unittest.TestCase):
    def setUp(self):
        init_django_conf()
        
    
class TestUpload(DjangoTestBase):
    def setUp(self):
        super(TestUpload, self).setUp()

    def test_upload_default(self):
        """
        default IMG_TYPE.DIARY, to https://pic.igengmei.com
        """
        with open('tests/a.jpeg', 'rb') as f:
            url = upload(f.read())
            self.assertTrue(url.startswith('https://'))
            # print(get_private_url_for_long(url))

    def test_upload_with_short_to_heras(self):
        """ test upload image to https://heras.igengmei.com
        """
        with open('tests/a.jpeg', 'rb') as f:
            key, short = upload_with_short(f.read(), IMG_TYPE.NOWATERMARK, '2019/02/21/heras')
            url = get_private_url(short, IMG_TYPE.NOWATERMARK)
            self.assertTrue(url.startswith('https://'))
            # print(url)

    def test_upload_with_short_to_igengmei(self):
        """ test upload image to https://pic.igengmei.com
        """
        with open('tests/a.jpeg', 'rb') as f:
            key, short = upload_with_short(f.read(), IMG_TYPE.WATERMARK, '2019/02/21/igengmei')
            url = get_private_url(short, IMG_TYPE.NOWATERMARK)
            self.assertTrue(url.startswith('https://'))
            # print(url)

    def test_upload_with_short_to_phonerecord(self):
        """ test upload image to http://phonerecord.private.igengmei.com
        """
        with open('tests/a.jpeg', 'rb') as f:
            key, short = upload_with_short(f.read(), IMG_TYPE.AUDIO, '2019/02/21/phonerecord')
            url = get_private_url(short, IMG_TYPE.AUDIO)
            self.assertTrue(url.startswith('http://'))
            # print(url)



class TestImgUrlField(DjangoTestBase):
    def setUp(self):
        super(TestImgUrlField, self).setUp()

    def test_ImgUrlField(self):
        image = ImgUrlField(img_type=IMG_TYPE.GREETINGPOPUP, verbose_name=u'图片地址', max_length=256)
        
