# -*- coding:UTF-8 -*-
# @Time  : 2021/1/6 10:21
# @File  : rpc_data_to_answer.py
# @email : litao@igengmei.com
# @author : litao

import requests
import typing
"""
https://www.yuque.com/docs/share/f4abe44b-6593-46b4-b280-5c87e4db2c85?#
rpc: cims/question/batch_create 创建问题
rpc: cims/answer/batch_create 创建回答
rpc: cims/reply/batch_create 创建评论
"""

platfrom_id_dict = {
    "zhihu":0,
    "weixin":1,
    "weibo":2,
    "hera":3,
    "insheadline":7,
    "kyc":8,
    "xiaohongshu":9,
    "gm":99
}

data_type_dict = {
    "cims/question/batch_create": ["platform","platform_id","title","content","user_id","create_time","is_online"],
    "cims/answer/batch_create": ["platform","platform_id","platform_question_id","content","user_id","create_time","is_online"],
    "cims/reply/batch_create": ["platform","platform_id","platform_answer_id","content","user_id","create_time","is_online"]
}


def post_data(data_dict:typing.Dict,rpc_type:str) -> typing.Dict:
    headers = {
        'X-GAIA-HELIOS-VERSION': '0.7.5',
    }
    for key in data_dict:
        if key not in data_type_dict[rpc_type]:
            data_dict.pop(key)
    print(data_dict)
    data = {
        'requests': '[{"params": {"replies": [{%s}]}, "method": "%s, "timeout": 120}]' % (str(data_dict),rpc_type)
    }
    response = requests.post('http://cims-qa.paas-develop.env/v1/batch', headers=headers, data=data)
    print(response.text)
    return response.json()