# coding=utf-8
from __future__ import absolute_import, unicode_literals
from ..utils.enum import Enum, unique


@unique
class SY_AUTHOR_TYPE(Enum):
    ZHIMA = 'zmxy', '芝麻信用'
    YUNYING = 'operator', '运营商'


@unique
class SY_AUTHOR_STATUS(Enum):
    AUT = '1', '授权成功'
    FAIL = '2', '授权失败'
    UNAUT = '3', '未认证'


@unique
class SY_IMAGE_TYPE(Enum):
    FRONT = '1', '身份证正面'
    BACK = '2', '身份证背面'
    HAND = '3', '手持身份证'
    PLAN = '4', '医疗确认单'


@unique
class SY_MARRIAGE(Enum):
    UNMARRIED = '0', '未婚'
    MARRIED = '1', '已婚'
    OTHER = '3', '其它'


@unique
class SY_EDUCATION(Enum):
    UNDER_SENIOR = '7', '高中以下'
    SENIOR = '5', '高中/中专'
    SPECIALTY = '4', '大专'
    BECHELOR = '3', '本科'
    MASTER = '2', '硕士研究生'
    DOCTOR = '1', '博士研究生／博士后'


@unique
class SY_CAREER(Enum):
    STUDENT = '1', '学生'
    WORKING = '2', '在职'
    SELF_EMPLOYED = '3', '自雇人士'
    FREE = '4', '自由职业'
    HOUSEWIFE = '5', '家庭主妇'
    NO_WORK = '7', '无业'


@unique
class SY_RELATION(Enum):
    PARENT = '0', '父母'
    SPOUSE = '2', '配偶'
    CHILD = '3', '子女'
    OTHER_FAM = '4', '其他亲戚'
    COLLEAGUE = '5', '同事'
    FRIEND = '6', '朋友/同学'


@unique
class SY_BANK(Enum):
    ICBC = '01020000', '中国工商银行'
    BOC = '01040000', '中国银行'
    CCB = '01050000', '中国建设银行'
    ECITIC = '63020000', '中信银行'
    CEB = '03030000', '光大银行'
    CIB = '03090010', '兴业银行'
    SPDB = '03100000', '上海浦东发展银行'
    SZPA = '05105840', '平安银行'
    ABC = '01030000', '中国农业银行'
    SHB = '04012900', '上海银行'
    CMBCHINA = '03080000', '招商银行'
    BOCO = '03010000', '中国交通银行'


@unique
class SY_ORDER_STATUS(Enum):
    INEFFECTIVE = '0', '未生效'
    PASS = '0A', '风控审核通过'
    SUCCESS = '1', '合同签署成功'
    REFUSE = '2', '审核拒绝'
    NORMAL_END = '3', '正常结束'
    EARLY_END = '4', '提前结束'
    CANCEL = '5', '已取消'


@unique
class SY_BILL_STATUS(Enum):
    UNPAY = '0', '未还款'
    PAYED = '1', '已支付'
    FAIL = '2', '扣款失败'
    PAYING = '3', '正在扣款'
    CANCEL = '-1', '取消'
