# coding=utf-8
from __future__ import unicode_literals, absolute_import
from .utils.enum import Enum, unique


@unique
class STATEMENT_OPERATION_TYPE(int, Enum):
    CREATE = (0, '生成对账单')
    APPLY = (1, '医生发起结算申请')
    AUDIT = (2, '审核通过')  # 运营审核完善金额
    CHECK = (3, '确认结算金额')
    REFUSE = (4, '申诉结算金额')
    SETTLE = (5, '打款到账')
    BANK_DEFEAT = (6, '打款失败,原因:账户错误')
    NAME_DEFEAT = (7, '打款失败,原因:户名不对')
    FIN_RESET = (8, '财务重置结算状态')  # 重置为医生已确认状态


@unique
class STATEMENT_STATUS(int, Enum):
    CREATED = (0, '已创建')  # 已生成
    APPLIED = (1, '已生成')  # 医生已发起结算申请
    AUDITED = (2, '待确认')  # 运营已审核完善金额
    CHECKED = (3, '待结算')  # 医生已确认最终结算单
    SETTLED = (4, '已结算')  # 已结算
    REFUSED = (5, '申诉中')  # 医生已拒绝
    DEFEAT = (6, '财务打款失败')  # 财务打款失败
    VOID = (9, '空对账单')  # 改医生当月无结算订单, 结算金额为0, 占位结算单


@unique
class OPERATION_ROLE(int, Enum):
    USER = (0, '用户操作')
    DOCTOR = (1, '医生操作')
    STAFF = (2, '内部员工操作')
    SYSTEM = (3, '系统操作')


@unique
class COUPON_TIME_TYPE(int, Enum):
    START_END = (0, '通过开始结束时间控制')
    COUNTDOWN = (1, '通过倒计时方式控制')


@unique
class SETTLEMENT_PAY_MODE(int, Enum):
    COMMON = (0, '普通支付')  # 微信支付宝applePay
    INSTALLMENT = (1, '分期支付')


@unique
class INSURANCE_TYPE(int, Enum):
    YINUO = (1, '一诺保险')
    ZHONGAN = (2, '众安保险')
