import elasticsearch
import smtplib
from email.message import EmailMessage
import datetime
import sys


def task_alert(days_from_running, f_log=None):
    email_group = {
        'task-stats': [
            'zhouyujiang@csm.com.cn',
            'hanye@csm.com.cn',
            "litao@csm.com.cn",
            "gengdi@csm.com.cn"
        ]
    }
    email_msg_suffix = ('\n\n\n'
                        + '-' * 80 + '\n'
                        + '这是自动发送的邮件，可以不用回复。\n'
                        + 'This is an automatically sent message. You do NOT need to reply.\n')

    es = elasticsearch.Elasticsearch(hosts='192.168.17.13', port=9200)
    index_task = 'task-stats'
#    doc_type_task = ''

    p = 86400000
    today = datetime.datetime.now() - datetime.timedelta(days=days_from_running)
    t = datetime.datetime(today.year, today.month, today.day)
    print(t)
    stamp = int(t.timestamp() * 1000)
    print(stamp)

    if f_log == None:
        path = '/home/zhouyujiang/zyj_log'
        log_fn = 'email_alert_for_%s_log' % datetime.datetime.strftime(today, '%b-%Y')
        f_log = open(path + log_fn, 'a')
        # pass
    else:
        f_log = sys.stdout

    print('*' * 80, file=f_log)
    print('log timestamp ', datetime.datetime.now(), file=f_log)
    print('Checking task for fetch_date', today.isoformat()[:10], file=f_log)

    alert_msg = {}
    for is_done in [ False,True]:
        alert_msg[is_done] = {}
        search_body = {
            "query": {
                "bool": {
                    "filter": [
                        {"term": {"is_done": is_done}},
                        {"range": {"start_time": {"gte": stamp - p, "lt": stamp}}}
                    ]
                }
            }
        }
        search_resp = es.search(index=index_task,
                                body=search_body,
                                request_timeout=100,
                                size=1000)
        task_num = search_resp['hits']['total']
        fetch_date_str = today.isoformat()[:10]
        for i in search_resp['hits']['hits']:
            index_name = i['_id']
            # print(index_name)
            try:
                alert_msg[is_done][index_name] = [i['_source']['task_description'], ]
            except:
                alert_msg[is_done][index_name] = ['', ]
            start_time_int = int(i['_source']['start_time'] / 1000)
            start_time_H = datetime.datetime.fromtimestamp(start_time_int).isoformat(sep=' ')
            alert_msg[is_done][index_name].append(start_time_H)
            try:
                end_time_int = int(i['_source']['end_time'] / 1000)
                end_time_H = datetime.datetime.fromtimestamp(end_time_int).isoformat(sep=' ')
                alert_msg[is_done][index_name].append(end_time_H)
            except:
                alert_msg[is_done][index_name].append('')

    # print("***********************************")
    # for j in alert_msg[True].keys():
    #     print(j)
    # print("***********************************")
    # for k in alert_msg[False].keys():
    #     print(k)

    # # send the alert email
    csm_mail_service = 'mail.csm.com.cn'
    sender = 'zhouyujiang@csm.com.cn'
    stats_type_dict = {
        True: '完成的任务',
        False: '未完成的任务'
    }
    email_subj = ' task-stats预警 %s' % (today.isoformat()[:10])
    email_msg_body = ''
    email_msg_body += '未完成任务/完成任务：%s/%s\n\n' %(len(alert_msg[False].keys()),len(alert_msg[True].keys()))
    for is_done in alert_msg:
        email_msg_body += ('%s ：\n' % (stats_type_dict[is_done]))
        for id in alert_msg[is_done].keys():
            email_msg_body += ('\t_id ：%s\n\ttask_description ：%s\n\tstart_time ：%s\n\tend_time ：%s\n' % (
                id, alert_msg[is_done][id][0], alert_msg[is_done][id][1], alert_msg[is_done][id][2]))
            email_msg_body += ('\n')
    email_msg_body += ('\n')
    email_msg_body += '\nchecking data source index name: %s\n\n\n' % (index_task)
    if email_msg_body != '':
        email_msg_body += email_msg_suffix
        print('email_msg_body:\n', email_msg_body, file=f_log)

    email_msg = EmailMessage()
    email_msg.set_content(email_msg_body)
    email_msg['Subject'] = email_subj
    email_msg['From'] = sender
    email_msg['to'] = email_group[index_task]

    try:
        server = smtplib.SMTP(host=csm_mail_service)
        server.send_message(email_msg)
        server.quit()
        print('Successfully sent email to %s for %s' % (email_group[index_task], index_task),
              datetime.datetime.now(), file=f_log)
        print('email_msg:\n', email_msg, file=f_log)
    except:
        print('Failed to connect email server.', datetime.datetime.now(), file=f_log)

    print('\n\n', file=f_log)
    f_log.close()


if __name__ == '__main__':
    task_alert(0)
