# -*- coding:utf-8 -*-
# @Time : 2019/8/8 17:09 
# @Author : litao
from func_cal_NI_by_redis import *
import datetime
import argparse

parser = argparse.ArgumentParser(description='Specify a platform name.')
parser.add_argument('-c', '--cycle', default="M", type=str,
                    help=('Please input a cycle type.such as week/month/quarter'))
parser.add_argument('-n', '--cycle_num', default=None, type=int,
                    help=('cycle_num. Such as 1/2/3/4/5'))
parser.add_argument('-y', '--year', default=None, type=int,
                    help=('Specify output file path, default None.'))
parser.add_argument('-t', '--type', default='all', type=str)
parser.add_argument('-redis', '--redis',default=10, type=int,
                    help=('redis_num'))
args = parser.parse_args()


def month_num(year=None, cycle=0, cycle_num=None):
    now = datetime.datetime.now()
    if not cycle_num:
        this_mon = now.month - cycle
        last_mon = this_mon - 1 if this_mon > 1 else this_mon - 1 + 12
        year = now.year
        if last_mon == 12:
            last_year = year - 1
        else:
            last_year = year
    else:
        this_mon = cycle_num - cycle
        last_mon = this_mon - 1 if this_mon > 1 else this_mon - 1 + 12
        year = year
        if last_mon == 12:
            last_year = year - 1
        else:
            last_year = year
    print(year, this_mon,last_year,last_mon)
    last_day_ts = int(datetime.datetime(year=year, month=this_mon, day=1).timestamp() * 1e3)
    first_day_ts = int(datetime.datetime(year=last_year, month=last_mon, day=1).timestamp() * 1e3)
    return first_day_ts, last_day_ts, last_mon

print(args.year,args.cycle_num)
if not args.cycle_num:
    release_time_st_now, release_time_et_now, target_mon = month_num()
    release_time_st_now_last, release_time_et_now_last, target_mon_last = month_num(cycle=1)
else:
    release_time_st_now, release_time_et_now,target_mon = month_num(year=args.year, cycle_num=args.cycle_num, cycle=-1)
    release_time_st_now_last, release_time_et_now_last,target_mon_last = month_num(year=args.year, cycle_num=args.cycle_num)
cal_type = 'M'
index_now = 'ronghe_weibo_monthly'
doc_type_now = 'doc'

if args.type:
    cal_type = args.type
else:
    cal_type = 'all'

if cal_type == 'new_released' or cal_type == 'all':
    func_cal_new_released_NI(cal_type=args.cycle,
                             release_time_st_now=release_time_st_now,
                             release_time_et_now=release_time_et_now,
                             index_now=index_now,
                             doc_type_now=doc_type_now,
                             #exter_list=exter_dict
                       )
if cal_type == 'observed' or cal_type == 'all':
    search_body = {
            "query": {
                    "bool": {
                            "filter": [
                                    {"range": {"release_time": {"gte": release_time_st_now_last,
                                                                "lt": release_time_et_now_last}}},
                                    {"terms": {"data_month": [target_mon_last]}}
                            ]
                    }
            }
    }
    now_body = {
            "query": {
                    "bool": {
                            "filter": [
                                    {"range": {"release_time": {"gte": release_time_st_now_last,
                                                                "lt": release_time_et_now_last}}},
                                    {"terms": {"data_month": [target_mon]}}
                            ]
                    }
            }
    }
    func_cal_increment(index_now, doc_type_now, args.cycle, index_now, doc_type_now,
                       search_body=search_body, now_body=now_body, target_id="wb_bowen_id",redis_db=args.redis
                       )
