# coding=utf-8
from __future__ import absolute_import, unicode_literals
from ..utils.enum import Enum, unique


@unique
class ERROR(int, Enum):
    """
    分配错误码时请参考、维护代码库根目录下的文件 ERROR_CODE_REGION.txt
    """
    AUTH_UNAME_PASSWD_MISMATCH = (1, 'username and password mismatch')
    ILLEGAL_SESSION = (2, 'illegal session or session not exist')

    UNSUPPORT_STRATEGY_TYPE = (220000, 'unsupport strategy type')
    LOGIN_REQUIRED = (70000, '请登录后再试')
    USER_NOT_FOUND = (70001, '找不到用户')
    OVER_AMOUNT = (70002, '余额不够')
    USER_CREATE_FAIL = (70003, '用户创建失败')
    INVITE_CODE_ERROR = (70004, '邀请码无效')
    PASSPHASE_CODE_ERROR = (70005, '口令无效')
    USER_IS_EXTRA = (70006, '用户已经存在')
    OPERATION_NOT_SUPPORTED = (70007, '非法操作')
    WITHDRAW_TOO_MUCH_TIME = (70008, '每周只可提现一次')
    WITHDRAW_TIME_EXCEED = (70009, '每月只可提现一次')    # 纷享购2期上线后，WITHDRAW_TOO_MUCH_TIME可废弃
    BIND_OP_ILLEGAL = (70010, '不能绑定自己')  # 分销商不能绑定自己
