# -*- coding: utf-8 -*-
from __future__ import unicode_literals, absolute_import

from ..utils.enum import Enum, unique


class PUSH_INFO_TYPE(Enum):
    """推送信息类型
    PUSH_TYPE名字被gaia占用
    """
    GM_PROTOCOL = (1, '更美协议链接')
    MESSAGE = (2, '私信通知')
    CTRL = (3, '控制消息')
    MESSAGE_READ = (4, '私信已读')
    CONSULTATION = (5, '视频面诊')
    STATION_NOTICE = (6, '站内通知')  # 目前用于线索通电话授权

class PUSH_URGENCY(int, Enum):
    NORMAL = (9, '普通推送')
    URGENT = (0, '紧急推送')


class JPUSH_FMT(int, Enum):
    NOTIFICATION = (0, 'notification')
    MESSAGE = (1, 'message')


@unique
class PUSH_STAT_CATEGORY(int, Enum):
    SERVICE_START_SALE = (1, '开团提醒')
    RECOVERY_REMINDING = (2, '恢复提醒')  # DERPECATED
    CONSULT = (3, '定制相关')
    ORDER = (4, '订单相关')  # DEPRECATED
    HERA_TOPIC = (5, 'hera话题')
    HERA_SERVICE = (6, 'hera美购')
    HERA_SPECIAL = (7, 'hera专题')
    HERA_DIARY = (8, 'hera日记本')
    HERA_ZONE = (9, 'hera圈子')
    HERA_WEBPAGE = (10, 'hera网页')
    HERA_ACTIVITY = (11, 'hera免费活动')
    ORDER_CREATE = (12, '下单成功')
    ORDER_VALIDATE = (13, '订单验证')
    ORDER_REFUND = (14, '退款成功')
    RECOVERY_PRE_OPERATION = (15, '术前提醒')
    RECOVERY_AFTER_OPERATION = (16, '术后提醒')
    RECOVERY_AFTER_OPERATION_DAYS = (17, '术后xx天提醒')
    HERA_ZHIBO = (18, 'hera直播')
    HERA_TAG = (19, 'hera标签')
    HERA_COLUMN = (20, 'hera专栏')
    HERA_QUESTION = (21, 'hera问题')
    HERA_ANSWER = (22, 'hera回答')
    HERA_TRACTATE = (23, 'hera帖子')


class APP_TYPE(Enum):
    USER = ('user', '用户版')
    DOCTOR = ('doctor', '医生版')
    MINI_DOCTOR = ('mini_doctor', 'mini医生版')


class SEGMENT_TYPE(Enum):
    '''添加用户分群需要在极光后台添加对应的用户分群，以及更新gm-push中的对应关系，'''
    ACTIVE_7_DAYS = (1, '最近7天内的活跃用户')
    NO_ACTIVE_7_DAYS = (2, '最近7天内非活跃用户')


class EventType(Enum):
    """推送触发事件类型"""
    SEARCH = ('search', u'搜索')
    EXPLORE_TOPIC = ('explore_topic', u'浏览帖子')
    EXPLORE_SERVICE = ('explore_service', u'浏览美购详情页')
    CONVERSATION = ('conversation', u'私信')


class PERSONAL_PUSH_TYPE(Enum):
    """
    个性化推送类型
    """
    FANS = ('FANS', '粉丝')
    VOTE = ('VOTE', '点赞')
    FAVOR = ('FAVOR', '收藏')
    REPLY = ('REPLY', '评论')
    DIARY_ALERT = ('DIARY_ALERT', '日记本提醒更新')
    INTEREST_CONTENT = ('INTEREST_CONTENT', '兴趣内容')
    Quality_Question = ('Quality_Question', '追问')
    CTR_FORECAST = ('CTR_FORECAST', 'ctr预估')


class HERA_TASK_TYPE(Enum):
    """Hera后台任务推送内型"""
    DEFAULT = (0, '其他')
    MESSAGE = (1, '消息推送')
    COUPON = (2, '美劵推送')


class AUTOMATED_PUSH(Enum):
    """
    自动化push
    社区、用户相关1-30
    交易、美购相关31-60
    其他类型61-99
    ctr个性化推送 100-120
    """
    QUESTION_POSTED_ANSWER = (1, '问题贴收到回答')
    DIARY_POST_RECEIVED_COMMENTS = (2, '日记帖收到评论')
    ANSWER_RECEIVED_COMMENTS = (3, '回答收到评论')
    COMMENT_RECEIVED_REPLY = (4, '评论收到回复')
    DIARY_POST_RECEIVED_PRAISE = (5, '日记帖收到赞')
    DIARY_RECEIVED_PRAISE = (6, '日记本收到赞')
    DIARY_IS_SUBSCRIBED = (7, '日记本被订阅(收藏)')
    JOURNAL_POST_IS_COLLECTED = (8, '日记帖被收藏')
    DIARY_CASHBACK_REMINDER = (9 , '日记返现提醒')
    JOURNAL_UPDATE_PROMPT = (10,'日记更新提示')
    PRE_OPERATIVE_ENCYCLOPEDIA = (11, '术前百科（支付后5min）')
    ANSWER_GET_VOTE = (12, '回答收到赞')
    TOPIC_REPLY_GET_VOTE = (13, '日记帖评论收到赞')

    TRACTATE_IS_COLLECTED = (14, '新帖子收藏')
    TRACTATE_GET_VOTED = (15, '新帖子点赞')
    TRACTATE_REPLY_GET_VOTED = (16, '新帖子回复点赞')
    TRACTATE_GET_REPLY = (17, '新帖子收到回复')
    TRACTATE_REPLY_GET_REPLY = (18, '新帖子评论收到回复')
    OPERATION_TRACTATE = (19, '运营发送用户帖子落地页')

    USER_LEVEL_UP = (20, '用户等级提升')
    USER_IS_CONCERNED = (21, '用户被关注')
    FOLLOWED_USER_IS_ANSWER_A_POST = (22, '关注的用户回答某贴')
    FOLLOWED_USER_PAID_A_QUESTION = (23, '关注的用户发布了提问')
    FOLLOWED_USER_POSTED_JOURNAL_POSTS = (24, '关注的用户发布了日记帖')
    NEW_CHECK_IN_REMINDER = (25, '新签到提醒')
    INVITATION_TO_ANSWER = (26, '邀请回答')
    ACTIVITY = (27, '活动提醒')
    HERA_TRACTATE_AUDIT = (28, 'hera帖子审核')
    FOLLOWED_USER_POSTED_LIVE = (29, '关注的用户发布了直播')
    NEW_CHECK_IN_RUSH_PRIZE = (30, '签到用户抢购商品')

    PAYMENT_REMINDER = (31, '支付提醒')
    PAYMENT_REFUNDED = (32, '订单退款成功')
    PAYMENT_EVALUATE = (33, '订单评价提醒')
    PAYMENT_AGAIN = (34, '复购提醒')
    PAYMENT_CASH_BACK = (35, '订单返现成功')
    PAYMENT_DIARY_UPDATE = (36, '已验证美购日记本更新')
    UNVERIFIED_US_PURCHASER = (40, '有未验证的美购')
    REMIND_SECKILL = (41, '秒杀提醒')
    US_COUPON_EXPIRED = (50, '美券N天后过期')
    US_COUPON_PROMPT_UPGRADE = (51, '美券提示升级')

    CUSTOMER_SERVICE_CONSULTATION = (61, '客服咨询')
    RECEIVED_A_PRIVATE_MESSAGE = (62, '收到私信')
    MESSAGE_HAS_BEEN_READ = (63, '私信已读')
    BASE_USER_INTEREST_FOR_CONTENT = (64, '基于用户对内容的兴趣')

    HERA_PUSH_ALL = (70, 'hera后台推送全部')
    HERA_PUSH_PERSONALITY = (71, 'hera后台个性化推送')

    CONSULTATION = (72, '视频面诊相关推送')
    STATION_NOTICE = (73, '站内通知相关')

    TRACTATE_CREATE = (80, '用户帖创建')
    ANSWER_REPLY_RECEIVED_VOTE = (81, '回答评论被赞')
    QUALITY_QUESTION = (85, '问答异形追问、回答推送')

    AI_RECALL = (92, 'AI用户召回推送')
    AI_SKIN_RECALL = (93, 'AI测过肤的用户召回推送')
    AI_NO_SKIN_RECALL = (94, 'AI未测过肤的用户召回推送')

    CTR_TRACTATE = (101, 'ctr推荐优质帖子')
    CTR_DIARY = (102, 'ctr推荐优质日记贴')
    CTR_ANSWER = (103, 'ctr推荐优质回答')
    CTR_INTEREST_QUESTION = (104, 'ctr推荐感兴趣的问题')
    CTR_REGION = (105, 'ctr按地域推荐')

    ACTION_RECALL_GROUP = (106, '意愿召回推送小组话题页')
    ACTION_RECALL_CONTENT_SPECIAL = (107, '意愿召回推送内容专题页')
    ACTION_RECALL_SEARCH_TRACTATE = (108, '意愿召回推送搜索帖子页')

    HOT_TRACTATE = (111, '非ctr用户推荐热点帖子')
    HOT_DIARY = (112, '非ctr用户推荐热日记贴')
    HOT_ANSWER = (113, '非ctr用户推荐热回答')


class TEMPLATE_TYPE(Enum):
    """
    微信消息模板类型
    """
    SUCCESSFUL_PROMOTION = (0, '晋级成功')
    IMG_AUDIT_FAILURE = (1, '图片审核失败')


class J_TYPE(Enum):
    """
    极光推送类型
    """
    NOTIFICATION = (0, '推送')
    MESSAGE = (1, '消息')
    NOTIFICATION_AND_MESSAGE = (2, '推送加消息')

# author:gaomingming
# 用于推送服务相关
# modify data:2019.07.10

class HERA_PUSH_TYPE2(Enum):
    """
    HERA后台推送类型
    单一美购、美购专场、日记本、免费活动、直播、专栏详情、问题详情
    """
    SERVICE = ('0', '单一美购')
    SPECIAL = ('1', '美购专场')
    DIARY = ('2', '日记本')
    ACTIVITY = ('3', '免费活动')
    ZHIBO = ('4', '直播')
    COLUMN = ('5', '专栏详情')
    QUESTION = ('6', '问题详情')
    TRACTATE = ('7', '帖子详情')
    POLYMER = ('8', '专题聚合')
    VISUAL_PAGE = ('9', '自定义专题页面')

class PUSH_USER_TYPE2(Enum):
    '''
        用户类型
    '''
    ALL = (0, u'全部')
    NEW_USER = (1, '新用户')
    OLD_USER = (2, '老用户')
    APPOINT_USER = (3, '指定用户')
    MARKET_USER = (4, '营销用户')

class HERA_PUSH_PLATFORM(Enum):
    '''
        推送平台
    '''
    ALL=(0,u'All')
    IOS=(1,u'iPhone')
    ANDROID=(2,u'Android')

class SEND_STATUS(Enum):
    '''
        发送状态
    '''
    CREATE=(0,'创建成功')
    READY=(1,'准备发送')
    SUCCESS=(2,'发送成功')
    FAILURE=(3,'发送失败')
    OFFLINE=(4,'下线')
    REVOKED=(5,'取消推送')


class PUSH_CONTENT_TYPE(Enum):
    """
    触发推送的内容类型，免打扰使用
    """
    DIARY = ('diary', '日记')
    TRACTATE = ('tractate', '帖子')
    QUESTION = ('question', '问题')
    ANSWER = ('answer', '回答')
    TOPIC = ('topic', '话题')


class PUSH_TAG(Enum):
    """
    按标签批量下发 Push 消息，可为每个用户打多个标签
    """
    NO_CTR = ('no_ctr', '无ctr画像')
    SKIN = ('skin', '已测肤')
    NO_SKIN = ('no_skin', '未测肤')
    NO_CTR_GRAY = ('no_ctr_gray', '无ctr画像50%灰度')
