# -*- coding: utf-8 -*-
"""
Created on Thu Oct  5 15:28:45 2017

@author: hanye
"""

import datetime, time
from func_calculate_monthly_net_inc import cal_monthly_net_inc
import logging
import task_stats

dayT_of_proc_data=datetime.datetime.now()-datetime.timedelta(days=1)

fetch_year=dayT_of_proc_data.year
fetch_month=dayT_of_proc_data.month
fetch_day=dayT_of_proc_data.day

# define logger
loggerName = 'calculate_monthly_net_inc'
logger=logging.getLogger(loggerName)
logger.setLevel(logging.DEBUG)
# create handler
path='/home/hanye/project_data/Python/Projects/proj-short-videos/write-data-into-es/log/'
log_fn='calculate_monthly_net_inc_for_%s_on_%s_log' % (dayT_of_proc_data.isoformat()[:10],
                                                       datetime.datetime.now().isoformat().replace(':','-'))
fh=logging.FileHandler(path+log_fn)
fh.setLevel(logging.INFO)
# create formatter and add it to the handler
formatter=logging.Formatter('%(asctime)s - %(name)s - %(levelname)s - %(message)s')
fh.setFormatter(formatter)
# add handler to logger
logger.addHandler(fh)


# calculate with awareness of the predecessor task status
logger.info('Find if the predecessor task is done')
day_str = datetime.datetime.now().isoformat()[:10]
pre_task_names = {
        'write_qingbo_TK_ATU_data_from_ftp_daily_task':
            {'days_str_of_proc_data': day_str},
        'write_fh_data_from_ftp_call_func_daily_task00':
            {'days_str_of_proc_data': day_str},
        }
time_of_processed_data_T = datetime.datetime.now() - datetime.timedelta(days=1)
task_stats.wait_for_pre_task_to_cal(
        pre_task_names, loggerName,
        cal_monthly_net_inc,
        (fetch_year, fetch_month, fetch_day),
        task_name='calculate_monthly_net_inc_call_func_daily',
        program_file_name='calculate_monthly_net_inc_call_func_daily.py',
        task_freq='daily',
        time_of_processed_data_T=time_of_processed_data_T
        )

logger.info('All done.')

#
#pre_task_done = []
#for tsknm in pre_task_names:
#    task_id = task_stats.form_task_doc_id(tsknm,
#                    pre_task_names[tsknm]['days_str_of_proc_data'])
#    pre_task_done.append(task_stats.is_task_done(task_id))
#    pre_task_names[tsknm]['task_id'] = task_id
#
#wait_start_T = datetime.datetime.now()
#while not all(pre_task_done):
#    logger.info('Not all predecessor tasks done, wait...')
#    time.sleep(60)
#    pre_task_done.clear()
#    for tsknm in pre_task_names:
#        task_id = pre_task_names[tsknm]['task_id']
#        pre_task_done.append(task_stats.is_task_done(task_id))
#    wait_present_T = datetime.datetime.now()
#    if (wait_present_T-wait_start_T).total_seconds()>24*3600:
#        logger.info('Have waited for 24 hours and not all predecessor task '
#                     'done, program exits.')
#        import sys
#        sys.exit(0)
#
#logger.info('All predecessor tasks done,')
#for tsknm in pre_task_names:
#    task_id = pre_task_names[tsknm]['task_id']
#    task_stats_data = task_stats.get_task_record(task_id)
#    done_at = task_stats_data['end_time']
#    pre_task_names[tsknm]['done_at'] = done_at
#    done_at_str = datetime.datetime.fromtimestamp(done_at/1e3).isoformat()
#    logger.info('Task %s done at %s' % (tsknm, done_at_str))
#
#logger.info('Will perform calcuate on monthly net increase values')
#
## write task status into task-stats index when starts
#task_start_ts = int(datetime.datetime.now().timestamp()*1e3)
#time_of_processed_data_T = datetime.datetime.now() - datetime.timedelta(days=1)
#
## sort to get consistent order in predecessor_task_id,
## predecessor_task_name and predecessor_task_done_time fields
#predecessor_task_name_Lst = sorted(list(pre_task_names.keys()))
#predecessor_task_done_time_Lst = []
#predecessor_task_id_Lst = []
#for tnm in predecessor_task_name_Lst:
#    predecessor_task_id_Lst.append(pre_task_names[tnm]['task_id'])
#    predecessor_task_done_time_Lst.append(pre_task_names[tnm]['done_at'])
#task_stats.record_task_stats(
#     task_name='calculate_monthly_net_inc_call_func_daily',
#     program_file_name='calculate_monthly_net_inc_call_func_daily.py',
#     task_freq='daily',
#     start_time=task_start_ts,
#     time_of_processed_data=int(time_of_processed_data_T.timestamp()*1e3),
#     predecessor_task_id=predecessor_task_id_Lst,
#     predecessor_task_name = predecessor_task_name_Lst,
#     predecessor_task_done_time=predecessor_task_done_time_Lst
#     )
#
#cal_monthly_net_inc(fetch_year, fetch_month, fetch_day)
#
## write task status into task-stats index when ends
#task_end_ts = int(datetime.datetime.now().timestamp()*1e3)
#task_stats.record_task_stats(
#     task_name='calculate_monthly_net_inc_call_func_daily',
#     program_file_name='calculate_monthly_net_inc_call_func_daily.py',
#     task_freq='daily',
#     start_time=task_start_ts,
#     time_of_processed_data=int(time_of_processed_data_T.timestamp()*1e3),
#     predecessor_task_id=predecessor_task_id_Lst,
#     predecessor_task_name = predecessor_task_name_Lst,
#     predecessor_task_done_time=predecessor_task_done_time_Lst,
#     end_time=task_end_ts,
#     is_done=True,
#     task_stats='Done',
#     )
