# rpc规范

## gaia的设计目标

### 数据源管理
	我们会使用mysql, postgresql, elasticsearch, redis 以后可能还会有cassendra  hadoop等数据源， 同时mysql postgresql也可能会是集群部署 分库分表。 
	我们不希望向业务方暴露数据源的复杂度，需要一个统一的方案来管理各种数据源和数据源之间的同步。
	
### 服务的远程调用
	随着业务的复杂（我们现在有新后台， 医生版， 移动网页版，pc网页版， 客户端， 以后可能还会增加其他的业务模块)， 很难用一个服务来实现所有的业务形态。 
	这些不同功能的业务可能由不同的开发团队开发，甚至会使用不同的开发语言。 所以需要一个统一的抽象层来共享业务逻辑。 需要一个统一风格的api，协议以及远程调用的实现，
	具有完善的文档调用，同时具备良好的性能，让业务方专注实现业务逻辑而不用关心具体的性能优化。
	

### 统一的缓存管理
	我们会使用统一的缓存方案，让尽可能多的用户读请求落到缓存里，写时更新。 保证数据源和缓存的数据最终一致性。
	
### 集群管理
	尽可能保证数据源，缓存，rpc服务器没有单点，保障系统的稳定性和扩展性。能够在任何一台服务器挂掉的情况下不影响系统的整体运行状态 
	
### 统一的监控管理
	会通过统一的日志方案，来对服务进行各种监控，一旦系统某一方面出现问题（服务器宕机，性能变慢，压力过大，磁盘占满，业务无法正常使用），
	监控系统能够第一时间发现问题并报警。通知相关业务人员处理问题。
	
	
	
## 面临的问题

### 开发风格混乱

	现在开发gaia的人过多，每个人的开发风格不一样，导致gaia代码质量比较混乱。比如目前gaia api命名没有一个统一的形式，我们系统里同时存在好几种不同风格的api命名。 
	有follow backend代码的api， 例如
		api/orders/my
		api/order/detail
		api/create_direct_pay
		
	有restful风格的命名方式
		api/doctors
	
	有名词+名词的
		api/tag/wiki
		api/tag/topics
	
	还有动词+名词+动词模式
		api/operation/audit/write_log
		api/operation/audit/query_my_log
		
	
### 包管理混乱
	现在gaia的包管理比较乱， 每个文件夹没有明确的定义。比如hera， 我们有一个api/hera目录，  同时也存在一个hera目录.