import redis
import logging
from django.conf import settings
from django.shortcuts import render
from math import radians, cos, sin, asin, sqrt
from django.http import HttpResponse,JsonResponse
import random
import requests
import ipdb
from gm_rpcd.all import bind,RPCDFaultException
#from rpc.decorators import bind_context, bind

r = redis.Redis(host=settings.REDIS_HOST, port=settings.REDIS_PORT,db=settings.REDIS_DB,password=settings.REDIS_PASSWORD,decode_responses=True)

rpc_client =settings.RPC_INVOKER
# Create your views here.

@bind('geoserver/home/nearly_hospitals')
def nearly_hospitals(q_lat,q_lng,radis=500,unit="km",count=20):
	'''
		查询最近医院
		@q_lnt 经度
		@q_lat 纬度
		@radis 方圆多少公里 
	'''
	#查询的经纬度
	#q_lat,q_lng=40.001930265172,116.4871890387796
	#数据缓存时间,现在为24小时
	cache_key="hospital_location"
	cache_diuration=24*60*60

	#ipdb.set_trace()
	if not r.exists(cache_key):
		print("地理位置信息过期---,重新拿取---")
		locations = rpc_client['api/hospital/location']().unwrap()
		#将地理位置信息加入redis缓存
		for item in locations:
			lat=item.get("baidu_loc_lat") if item.get("baidu_loc_lat") else item.get("google_loc_lat")
			lng=item.get("baidu_loc_lng") if item.get("baidu_loc_lng") else item.get("google_loc_lng")

			try:
				r.geoadd(cache_key,float(lng),float(lat),item.get("id"))
			except Exception as e:
				print(e)
				pass
		r.expire(cache_key,cache_diuration)

	result=r.georadius(cache_key,q_lng,q_lat,radis,unit,withdist=True,count=20)

	data={
		"result":True,
		"data":result,
		"message":""
	}
	return data


def get_location_by_address(request,address):
    """由地址获获取经纬度坐标

    :param address: 目标地址 '西城区西什库大街8号(近地安门西大街)
    :return: 经纬度信息 {"lng": 116.306735, "lat": 39.982951}
    """
    QQ_MAP_KEY = random.choice(settings.QQ_MAP_KEYS)

    params = {
        'address': address,
        'key': QQ_MAP_KEY,
        'output': 'json',
    }
    url = 'http://apis.map.qq.com/ws/geocoder/v1'
    response = requests.get(url, params=params)
    result = response.json()
    if result['status'] == 0:
        return result['result']['location']
    else:
        return None
	
