import redis
import logging
from django.conf import settings
from django.shortcuts import render
from math import radians, cos, sin, asin, sqrt
from django.http import HttpResponse,JsonResponse
import random
import requests
import ipdb
from gm_rpcd.all import bind,RPCDFaultException

r = redis.Redis(host=settings.REDIS_HOST, port=settings.REDIS_PORT,db=settings.REDIS_DB,password=settings.REDIS_PASSWORD,decode_responses=True)
rpc_client =settings.RPC_INVOKER


def refresh_cache_locations():
	'''刷新缓存中医院的数据'''
	print("地理位置信息过期---,重新拿取---")
	locations = rpc_client['api/hospital/location']().unwrap()

	cache_key="hospital_location"
	cache_diuration=24*60*60
	#将地理位置信息加入redis缓存
	for item in locations:
		lat=item.get("baidu_loc_lat") if item.get("baidu_loc_lat") else item.get("google_loc_lat")
		lng=item.get("baidu_loc_lng") if item.get("baidu_loc_lng") else item.get("google_loc_lng")

		try:
			r.geoadd(cache_key,float(lng),float(lat),item.get("id"))
		except Exception as e:
			print(e)
			pass
	r.expire(cache_key,cache_diuration)