import requests
import pytest

from utils.gmhttp import require_login
from .livecase import LiveCase
from conf import settings


class LiveBeauty(LiveCase):
    '''主播获取+设置相机美颜'''

    def setUp(self):
        uri = '/api/janus/live/beauty'
        self.url = self.host + uri
        self.params = dict(settings.GENGMEI_PARAMS, **{
            'channel_id': self.channel_id
        })

    @require_login(settings.LIVE_USER)
    def _live_beauty(self):
        '''
        主播获取相机美颜设置
        '''
        rep = requests.get(self.url, params=self.params).json()
        return rep

    @pytest.mark.get
    @require_login(settings.LIVE_USER)
    def test_live_beauty(self):
        '''
        主播获取相机美颜设置
        '''
        rep = self._live_beauty()
        self.assertEqual(rep['error'], 0, rep)
        self.assertIn(rep['data']['is_open'], (0, 1), rep)
        self.assertGreaterEqual(rep['data']['smooth'], 0, rep)
        self.assertLessEqual(rep['data']['smooth'], 1, rep)
        self.assertGreaterEqual(rep['data']['white'], 0, rep)
        self.assertLessEqual(rep['data']['white'], 1, rep)
        self.assertGreaterEqual(rep['data']['rosy'], 0, rep)
        self.assertLessEqual(rep['data']['rosy'], 1, rep)
        print('主播获取相机美颜设置成功！')

    @pytest.mark.post
    @require_login(settings.LIVE_USER)
    def test_live_beauty(self):
        '''
        主播设置相机美颜设置
        '''
        import random
        is_open, rosy, smooth, white = random.choice((0, 1)), round(random.random(), 2), \
                                       round(random.random(), 2), round(random.random(), 2)
        data = {
            "channel_id": self.channel_id,
            "is_open": is_open,
            "rosy": rosy,
            "smooth": smooth,
            "white": white
        }
        rep = requests.post(self.url, data=data).json()
        self.assertEqual(rep['error'], 0, rep)
        print('主播设置相机美颜设置成功！')

        n_rep = self._live_beauty()
        self.assertEqual(n_rep['data']['is_open'], is_open, rep)
        self.assertEqual(n_rep['data']['smooth'], smooth, rep)
        self.assertEqual(n_rep['data']['white'], white, rep)
        self.assertEqual(n_rep['data']['rosy'], rosy, rep)
        print('主播校验相机美颜设置成功！')
