import requests
import pytest

from utils.gmhttp import require_login
from .livecase import LiveCase
from conf import settings
from ddt import ddt, data


@ddt
class LiveSearchService(LiveCase):
    '''直播间搜索美购'''

    def setUp(self):
        uri = '/api/janus/live/search_service'
        self.url = self.host + uri
        self.params = dict(settings.GENGMEI_PARAMS, **{
            'channel_id': self.channel_id,
            'offset': 0,
            'size': 20
        })

    @pytest.mark.get
    @pytest.mark.run(order=settings.SEARCH_ORER)
    @data(*[settings.EMPUTY, settings.PROJECT_NAME, settings.HOSPITAL_NAME])
    def test_live_search_service(self, value):
        '''
        直播间搜索美购
        '''
        q = value
        self.params.update(query=q)
        rep = requests.get(self.url, params=self.params).json()
        self.assertEqual(rep['error'], 0, rep)
        # 理论上说每次搜索都有结果的
        services = rep['data']['services']
        self.assertIsInstance(services, list, rep)
        if q != settings.EMPUTY:
            # 防止数据较少情况，仅对前两条进行判断
            [self.assertIn(q, item['service_name'] + item['hospital_name']) for item in services[:2]]
        # 对 外显的价格 销量和距离进行关键字断言
        [self.assertNotEqual(item['display_price'], '') for item in services]
        [self.assertNotEqual(item['distance'], '') for item in services]
        [self.assertNotEqual(item['sell_num_desc'], '') for item in services]
        if q == settings.EMPUTY:
            LiveCase.service_ids = [item['service_id'] for item in services]
        print('直播间搜索美购成功！')
