# 封装一次 session
import requests
import sys

from functools import wraps
from copy import deepcopy
from conf import settings


# 使用from import * 仅允许require_login
__all__ = ['require_login']


class LoginFailedException(Exception):
    '''
    登录失败
    '''
    pass


# 支持更换用户
def require_login(arg=None, **user_dict):
    '''
    依然使用requests，只不过在使用过程中被替换成了gmhttp
    :param func:
    :return:
    '''

    def outer(func):
        @wraps(func)
        def _inner(*args, **kwargs):
            # 哈哈，不知道写啥
            try:
                newhttp = _Gmhttp.instance(**user_dict)
            except LoginFailedException:
                # 登录失败后，使用无登录状态尝试访问
                return func(*args, **kwargs)

            # 为了减少修改原有代码结构，仅需要对测试case添加装饰器require_login
            func_module = sys.modules.get(func.__module__)
            source_requests = getattr(func_module, 'requests')
            setattr(func_module, 'requests', newhttp)
            require_login.uid = newhttp.uid
            try:
                return func(*args, **kwargs)
            except AssertionError as e:
                raise e
            except Exception as e:
                raise e
            finally:
                setattr(func_module, 'requests', source_requests)
        return _inner

    # 为了兼容@require_login  直接使用
    if callable(arg):
        return outer(arg)
    return outer


# 内部使用
class _Gmhttp(requests.Session):
    '''
    封装一个类，提供request的各种方法
    '''
    _params = settings.GENGMEI_PARAMS
    _host = settings.BACKEND_ADMIN
    _userinfo = settings.LIVE_USER
    _exist_user_objs = {}


    def __init__(self, phone, password, *args, **kwargs):
        '''
        传一些默认值
        :param args:
        :param kwargs:
        '''
        super().__init__(*args, **kwargs)
        self.phone = phone
        self.password = password
        self.params = self._params
        self.verify = False  # 避开证书

    def reset(self):
        # 用于灰度params的设置
        self.params = deepcopy(self._params)

    @classmethod
    def instance(cls,  **userinfo):
        # 登录，如果phone和password有任意None 则使用默认账户
        phone = userinfo.get('phone', _Gmhttp._userinfo['phone'])
        password = userinfo.get('password', _Gmhttp._userinfo['password'])
        # 先获取是否已经实例化，若有直接返回实例
        obj = _Gmhttp._exist_user_objs.get(phone, None)
        if obj == None:
            # 防止多次条用登录接口
            obj = _Gmhttp(phone, password)
            obj.login()
            _Gmhttp._exist_user_objs[phone] = obj
        return obj

    def login(self):
        # 没有实例，进行实例化
        data = {"phone": self.phone, 'password': self.password}
        rep = self.post(
            url=_Gmhttp._host + '/api/accounts/login/password',
            data=data
        )

        try:
            res = rep.json()
        except:
            pass
        else:
            if res['error'] != 0:
                raise LoginFailedException('登录失败', res['message'])
            self.uid = res['data']['uid']

    def logout(self):
        '''
        登出
        :return:
        '''
        rep = self.post(
            url=self._host + '/api/accounts/logout',
            data=self._userinfo
        )
        try:
            res = rep.json()
        except:
            pass
        else:
            if res['error'] == 0 and res['message'] == '注销成功':
                _Gmhttp._exist_user_objs.pop(self.phone)

    def __del__(self):
        self.close()
