import requests

from utils.gmhttp import require_login
from .livecase import LiveCase
from conf import settings


class LiveSendMsg(LiveCase):
    '''发送弹幕'''

    def setUp(self):
        uri = '/api/live/sendmsg'
        self.url = self.host + uri
        self.data = {'channel_id': self.channel_id,
                     'msg': '这是一条羞涩的弹幕'
                     }
        self.data_warn = {'channel_id': self.channel_id,
                          'msg': '习近平，该条弹幕应被拦截'
                          }

    def test_live_sendmsg_visitor(self):
        '''
        游客发送弹幕
        '''
        rep = requests.post(self.url, data=self.data).json()
        self.assertEqual(rep['error_code'], 70000, rep)
        print('提示游客登录。')

    @require_login(settings.LIVE_WATCHER)
    def test_live_sendmsg_user(self):
        '''
        app用户发送弹幕
        '''
        rep = requests.post(self.url, data=self.data).json()
        self.assertEqual(rep['error'], 1, rep)
        print('app用户发送弹幕成功！')

    @require_login(settings.LIVE_USER)
    def test_live_sendmsg_author(self):
        '''
        主播发送弹幕
        '''
        rep = requests.post(self.url, self.data).json()
        self.assertEqual(rep['error'], 0, rep)
        print('主播发送弹幕成功！')

    @require_login(settings.LIVE_WATCHER)
    def test_live_sendmsg_warn(self):
        '''
        发送敏感词被成功拦截
        '''
        rep = requests.post(self.url, data=self.data_warn).json()

        self.assertEqual(rep['error_code'], 96604, rep)
        self.assertEqual(rep['message'], '您输入的内容包含敏感信息，请重新输入', rep)
        print('敏感词拦截成功！')

    @require_login(settings.LIVE_WATCHER)
    def test_live_sendmsg_interval(self):
        '''
        频繁发送弹幕的限制，这里只做单个人的限制验证，其他case已覆盖不同用户的误限制验证
        '''
        # 不管这条在前还是在后，直接先等个时间
        import time
        time.sleep(settings.SEND_MSG_TIME)
        requests.post(self.url, data=self.data).json()
        rep = requests.post(self.url, data=self.data).json()
        self.assertEqual(rep['error_code'], 13, rep)
        self.assertEqual(rep['message'], '您发送弹幕过于频繁了,请稍后再试', rep)
        print('频繁发送限制成功！')
        time.sleep(settings.SEND_MSG_TIME)
        rep = requests.post(self.url, data=self.data).json()
        self.assertEqual(rep['error'], 0, rep)
        print(f'间隔{settings.SEND_MSG_TIME}时间后发送弹幕成功！')