import requests
import pytest

from utils.gmhttp import require_login
from .livecase import LiveCase
from conf import settings


class LiveDeleteService(LiveCase):
    '''直播间删除美购'''

    def setUp(self):
        uri = '/api/janus/live/delete_live_service'
        self.url = self.host + uri
        self.data = {
            'channel_id': self.channel_id
        }

    @pytest.mark.post
    @pytest.mark.run(order=settings.DELETE_SERVICE_ORER)
    @require_login(settings.LIVE_USER)
    def test_live_delete_service(self):
        '''
        直播间删除美购
        '''
        self.data.update(live_service_id=LiveCase.service_ids[0])
        rep = requests.post(self.url, data=self.data).json()
        self.assertEqual(rep['error'], 0, rep)
        self.assertEqual(rep['data']['toast'], '商品已删除', rep)  # 不做具体内容判断，在添加的用例里会有相关部分判断

        print('直播间删除美购成功！')
