import requests
import pytest

from utils.gmhttp import require_login
from .livecase import LiveCase
from conf import settings


class LiveMarkService(LiveCase):
    '''直播间删除美购'''

    def setUp(self):
        uri = '/api/janus/live/mark_live_service'
        self.url = self.host + uri
        self.data = {
            'channel_id': self.channel_id,
            'stream_id':self.stream_id
        }

    @pytest.mark.post
    @pytest.mark.run(order=settings.MARK_SERVICE)
    @require_login(settings.LIVE_USER)
    def test_live_mark_service(self):
        '''
        直播间标记美购
        '''
        self.data.update(live_service_id=LiveCase.service_ids[0],mark_status=1)
        rep = requests.post(self.url, data=self.data).json()
        self.assertEqual(rep['error'], 0, rep)
        self.assertEqual(rep['data']['toast'], "操作成功", rep)  # 不做具体内容判断，在添加的用例里会有相关部分判断

        print('直播间标记美购成功！')

    @pytest.mark.post
    @pytest.mark.run(order=settings.UNDO_MARK_SERVICE)
    @require_login(settings.LIVE_USER)
    def test_live_unmark_service(self):
        '''
        直播间取消标记美购
        '''
        self.data.update(live_service_id=LiveCase.service_ids[0],mark_status=0)
        rep = requests.post(self.url, data=self.data).json()
        self.assertEqual(rep['error'], 0, rep)
        self.assertEqual(rep['data']['toast'], "操作成功", rep)  # 不做具体内容判断，在添加的用例里会有相关部分判断

        print('直播间取消标记美购成功！')
