import requests

from utils.gmhttp import require_login
from .livecase import LiveCase
from conf import settings


class LiveEnter(LiveCase):
    '''进入直播间'''

    def setUp(self):
        uri = '/api/live/enter'
        self.url = self.host + uri
        self.params = dict(settings.GENGMEI_PARAMS, **{
            'channel_id': self.channel_id
        })

    def test_live_enter_visitor(self):
        '''
        游客进入直播间
        '''
        rep = requests.get(self.url, params=self.params).json()
        self.assertEqual(rep['error'], 0, rep)
        print('游客进入直播间成功！')

    @require_login(settings.LIVE_WATCHER)
    def test_live_enter_user(self):
        '''
        app用户进入直播间
        '''
        rep = requests.get(self.url, params=self.params).json()
        self.assertEqual(rep['error'], 0, rep)
        print('app用户进入直播间成功！')

    @require_login(settings.LIVE_USER)
    def test_live_enter_author(self):
        '''
        主播进入直播间
        '''
        rep = requests.get(self.url, params=self.params).json()
        self.assertEqual(rep['error'], 0, rep)
        print('主播进入直播间成功！')
