import requests
from utils.gmhttp import require_login
from .livecase import LiveCase
from conf import settings
class LivePolling(LiveCase):
    def setUp(self):
        uri = '/api/janus/live/polling'
        self.url = self.host + uri
        self.params = dict(settings.GENGMEI_PARAMS, **{
            'stream_id': self.stream_id
        })

    def test_live_polling_visitor(self):
        '''
        游客直播间轮询接口
        '''
        rep = requests.get(self.url, params=self.params).json()
        self.assertEqual(rep['error'], 0, rep)
        print('polling轮询接口执行成功')

    @require_login(settings.LIVE_WATCHER)
    def test_live_polling_user(self):
        '''
        用户直播间轮询接口
        '''
        rep = requests.get(self.url, params=self.params).json()
        self.assertEqual(rep['error'], 0, rep)
        print('用户polling轮询接口执行成功')

    @require_login(settings.LIVE_USER)
    def test_live_polling_author(self):
        '''
        主播直播间轮询接口
        '''
        rep = requests.get(self.url, params=self.params).json()
        self.assertEqual(rep['error'], 0, rep)
        print('主播polling轮询接口执行成功')
