import unittest
import requests

from conf import settings
from utils.gmhttp import require_login


class LiveCase(unittest.TestCase):
    '''

    '''
    channel_id = None
    stream_id = None
    service_ids = None

    @classmethod
    def setUpClass(cls):
        # 做一些前置条件
        '''
        1. 创建直播
        2. hera上为直播做配置
        :return:
        '''
        cls.host = settings.BACKEND_ADMIN
        cls.create_live()
        cls.stream_info()

    @classmethod
    def tearDownClass(cls):
        cls.close_live()

    @classmethod
    @require_login
    def create_live(cls):
        '''
        创建直播间
        :return:
        '''
        if cls.live_status():
            return
        uri = '/api/live/push_live_info'
        url = settings.BACKEND_ADMIN + uri
        params = dict(settings.GENGMEI_PARAMS,
                      **{
                          'notice': '测试',
                          'tag_id': 3161,
                          'title': '测试',
                          'cover_url': '2021/01/04/1506/ba72d863e638',
                          'device_type': 1
                      }
                      )
        r = requests.get(url, params=params).json()
        cls.channel_id = r['data']['channel']
        print('创建直播间成功！')

    @classmethod
    @require_login
    def close_live(cls):
        '''
        关闭直播间
        :return:
        '''
        if cls.stream_id == None:
            print('没有成功创建直播间!')
            return
        uri = '/api/live/finish'
        url = settings.BACKEND_ADMIN + uri
        data = {'channel_id': cls.channel_id}
        r = requests.post(url, data=data).json()
        if r['error'] == 0:
            print('关闭直播间成功！')

    @classmethod
    @require_login
    def stream_info(cls):
        if cls.stream_id:
            return
        uri = '/api/live/get_live_info/anchor'
        url = settings.BACKEND_ADMIN + uri
        params = dict(settings.GENGMEI_PARAMS, channel_id=cls.channel_id)
        r = requests.get(url, params=params).json()
        cls.stream_id = r['data']['id']

    @classmethod
    def live_status(cls):
        if not cls.stream_id:
            return False
        uri = '/api/janus/live/polling'
        url = settings.BACKEND_ADMIN + uri
        params = dict(settings.GENGMEI_PARAMS, stream_id=cls.stream_id)
        r = requests.get(url, params=params).json()
        return not r['data']['stream_status']['is_finish']

    @classmethod
    def live_services(cls):
        uri = '/api/janus/live/live_services'
        url = settings.BACKEND_ADMIN + uri
        params = dict(settings.GENGMEI_PARAMS, channel_id=cls.channel_id, stream_id=cls.stream_id, offset=0, size=20)
        r = requests.get(url, params=params).json()
        return r

    # @classmethod
    # def live_add_service(cls):
    #     uri = '/api/janus/live/add_live_service'
    #     url = settings.BACKEND_ADMIN + uri
    #     params = dict(settings.GENGMEI_PARAMS, channel_id=cls.channel_id, stream_id=cls.stream_id, offset=0, size=20)
    #     r = requests.get(url, params=params).json()
    #     return r
