import requests
import pytest

from utils.gmhttp import require_login
from .livecase import LiveCase
from conf import settings


class LiveAddService(LiveCase):
    '''直播添加美购'''

    def setUp(self):
        uri = '/api/janus/live/add_live_service'
        self.url = self.host + uri
        self.data = {
            'channel_id': self.channel_id
        }

    @pytest.mark.post
    @pytest.mark.run(order=settings.ADD_SERVICE_ONE_ORER)
    @require_login(settings.LIVE_USER)
    def test_live_add_service_one(self):
        '''
        主播添加单个美购
        '''
        self.data.update(service_item_ids=f'{LiveCase.service_ids[0]}')
        rep = requests.post(self.url, data=self.data).json()
        self.assertEqual(rep['error'], 0, rep)
        self.assertEqual(rep['data']['toast'], '成功添加1件商品', rep)

        print('主播添加单个美购成功！')

    @pytest.mark.post
    @pytest.mark.run(order=settings.ADD_SERVICE_MANY_ORER)
    @require_login(settings.LIVE_USER)
    def test_live_add_service_many(self):
        '''
        主播添加多个美购
        '''
        import random
        num = random.choice(range(2, 10))  # 2-9个先写死
        self.data.update(service_item_ids=','.join(LiveCase.service_ids[-num:]))
        rep = requests.post(self.url, data=self.data).json()
        self.assertEqual(rep['error'], 0, rep)
        self.assertEqual(rep['data']['toast'], f'成功添加{num}件商品', rep)

        print(f'主播添加{num}个美购成功！')
