import requests

from utils.gmhttp import require_login
from .livecase import LiveCase
from conf import settings


class LiveDanmuV2(LiveCase):
    '''获取弹幕'''
    # 回放的弹幕，正在直播的弹幕没有逻辑上的区别

    def setUp(self):
        uri = '/api/live/danmu_v2'
        self.url = self.host + uri
        self.params = dict(settings.GENGMEI_PARAMS, **{
            'channel_id': self.channel_id
        })

    def test_live_danmu_v2(self):
        '''
        游客获取弹幕
        '''
        rep = requests.get(self.url, params=self.params).json()
        self.assertEqual(rep['error'], 0, rep)
        print('游客获取弹幕成功！')

    @require_login(settings.LIVE_WATCHER)
    def test_live_enter_user(self):
        '''
        app用户获取弹幕
        '''
        rep = requests.get(self.url, params=self.params).json()
        self.assertEqual(rep['error'], 0, rep)
        print('app用户获取弹幕成功！')

    @require_login(settings.LIVE_USER)
    def test_live_enter_author(self):
        '''
        主播获取弹幕
        '''
        rep = requests.get(self.url, params=self.params).json()
        self.assertEqual(rep['error'], 0, rep)
        print('主播获取弹幕成功！')
