import unittest
import requests

from conf import settings
from utils.gmhttp import require_login


class LiveCase(unittest.TestCase):
    live_id = None

    @classmethod
    def setUpClass(cls):
        # 做一些前置条件
        '''
        1. 创建直播
        2. hera上为直播做配置
        :return:
        '''
        cls.create_live()

    @classmethod
    def tearDownClass(cls):
        cls.close_live()

    @classmethod
    @require_login
    def create_live(cls):
        '''
        创建直播间
        :return:
        '''
        uri = '/api/live/push_live_info'
        url = settings.BACKEND_ADMIN + uri
        params = settings.GENGMEI_PARAMS.update(
            {
                'notice': '测试',
                'tag_id': 3161,
                'title': '测试',
                'cover_url': '2021/01/04/1506/ba72d863e638',
                'device_type': 1
            }
        )
        r = requests.get(url, params=params).json()

        cls.live_id = r['data']['channel']

    @classmethod
    @require_login
    def close_live(cls):
        '''
        关闭直播间
        :return:
        '''
        if cls.live_id == None:
            print('没有成功创建直播间!')
            return
        uri = '/api/live/finish'
        url = settings.BACKEND_ADMIN + uri
        data = {'channel_id': cls.live_id}
        r = requests.post(url, data=data).json()
        if r['error'] == 0:
            print('关闭直播间成功！')
