package com.gmei.data.dqmp.common;

public class Constants {

	// ***************校验类型******************
	// 唯一性校验
	public static final String CHECK_UNIQUE = "unique_check";
	// 非空性校验
	public static final String CHECK_UNBLANK = "unblank_check";
	// 参照性校验
	public static final String CHECK_REFER = "refer_check";
	// 波动性校验
	public static final String CHECK_VOLATILITY = "volatility_check";
	// 特殊性校验
	public static final String CHECK_SPECIAL = "special_check";

	// ***************监控指标类型******************
	// 波动性监控-PV
	public static final String MONITOR_PV = "PV";
	// 波动性监控-UV
	public static final String MONITOR_UV = "UV";

	// ***************是否有效******************
	// 有效
	public static final Integer IS_VALID_ON = 1;
	// 无效
	public static final Integer IS_VALID_OFF = 0;

	// ***************校验规则映射******************
	// 校验规则映射
	public static final String CHECK_RULE_MAPPING = "check_rule_mapping";

	// ***************规则类型映射******************
	// 单表规则类型
	public static final String TABLE_SIMPLE = "simple";
	// 双表规则类型
	public static final String TABLE_DUPLEX = "duplex";

	public static final String UNIQUE = "unique";
	public static final String UNBLANK = "unblank";
	public static final String REFER = "refer";
	public static final String VOLATILITY = "volatility";
	public static final String SPECIAL = "special";

}
