package com.gmei.data.dqmp.controller;

import javax.validation.Valid;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.gmei.data.dqmp.service.DqRuleService;
import com.gmei.data.dqmp.vo.DqRuleVo;

@Controller
@RequestMapping(value = "/dqRule")
public class DqRuleController extends BaseController{

	@Autowired
	private DqRuleService dqRuleService;
	
	/**
	 * 校验规则新增
	 * @param dqRuleVo
	 * @param bindingResult
	 * @return
	 */
    @RequestMapping(value = "/add", method = RequestMethod.POST)
    public String addDqRule(@RequestBody @Valid DqRuleVo dqRuleVo,BindingResult bindingResult, Model model) {
		if (bindingResult.hasErrors()) {
            return model(model,false,bindingResult.getFieldError().getDefaultMessage());
        }
		Boolean isAddSuc = dqRuleService.addDqRule(dqRuleVo);
		if(isAddSuc) {
			return model(model,true,"");
		}else {
			return model(model,false,"Rule add error!");
		}
    }
	
    @RequestMapping(value = "/del", method = RequestMethod.GET)
    public String delDqRule(DqRuleVo dqRuleVo, Model model) {
		if(dqRuleVo.getId() == null || StringUtils.isBlank(dqRuleVo.getCheckType())) {
			return model(model,false,"Params is error!");
		}
		Boolean isDelSuc = dqRuleService.delDqRule(dqRuleVo);
		if(isDelSuc) {
			return model(model,true,"");
		}else {
			return model(model,false,"数据质量规则删除失败!");
		}
    }
}
