package com.gmei.data.dqmp.controller;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import com.alibaba.excel.support.ExcelTypeEnum;
import com.gmei.data.dqmp.common.Constants;
import com.gmei.data.dqmp.service.DqRuleService;
import com.gmei.data.dqmp.utils.ImportExcelUtils;
import com.gmei.data.dqmp.vo.BaseVo;

@Controller
@RequestMapping(value = "/excel")
public class DqRuleImportController extends BaseController{

	@Autowired
	private DqRuleService dqRuleService;
	private static final Logger logger = LoggerFactory.getLogger(DqRuleImportController.class);

	@PostMapping(value = "export")
	public BaseVo exportExcel() {
		return new BaseVo();
	}

	@PostMapping(value = "importUnique")
	public String importUniqueExcel(HttpServletRequest httpServletRequest, Model model) {
		if (!checkIsLegal(httpServletRequest, Constants.UNIQUE)) {
			return model(model,false,"上传的数据质量规则文件格式或内容错误，请核实!");
		}
		try {
			ImportExcelUtils.saxReadUniqueListString(httpServletRequest, dqRuleService);
		} catch (Exception e) {
			logger.error(e.getMessage());
			return model(model,false,e.getMessage());
		}
		return model(model,true,"");
	}

	@PostMapping(value = "importUnblank")
	public String importUnblankExcel(HttpServletRequest httpServletRequest, Model model) {
		if (!checkIsLegal(httpServletRequest, Constants.UNBLANK)) {
			return model(model,false,"上传的数据质量规则文件格式或内容错误，请核实!");
		}
		try {
			ImportExcelUtils.saxReadUnblankListString(httpServletRequest, dqRuleService);
		} catch (Exception e) {
			logger.error(e.getMessage());
			return model(model,false,e.getMessage());
		}
		return model(model,true,"");
	}

	@PostMapping(value = "importRefer")
	public String importReferExcel(HttpServletRequest httpServletRequest, Model model) {
		if (!checkIsLegal(httpServletRequest, Constants.REFER)) {
			return model(model,false,"上传的数据质量规则文件格式或内容错误，请核实!");
		}
		try {
			ImportExcelUtils.saxReadReferListString(httpServletRequest, dqRuleService);
		} catch (Exception e) {
			logger.error(e.getMessage());
			return model(model,false,e.getMessage());
		}
		return model(model,true,"");
	}

	@PostMapping(value = "importVolatility")
	public String importVolatilityExcel(HttpServletRequest httpServletRequest, Model model) {
		if (!checkIsLegal(httpServletRequest, Constants.VOLATILITY)) {
			return model(model,false,"上传的数据质量规则文件格式或内容错误，请核实!");
		}
		try {
			ImportExcelUtils.saxReadVolatilityListString(httpServletRequest, dqRuleService);
		} catch (Exception e) {
			logger.error(e.getMessage());
			return model(model,false,e.getMessage());
		}
		return model(model,true,"");
	}

	@PostMapping(value = "importSpecial")
	public String importExcel(HttpServletRequest httpServletRequest, Model model) {
		if (!checkIsLegal(httpServletRequest, Constants.SPECIAL)) {
			return model(model,false,"上传的数据质量规则文件格式或内容错误，请核实!");
		}
		try {
			ImportExcelUtils.saxReadSpecialListString(httpServletRequest, dqRuleService);
		} catch (Exception e) {
			logger.error(e.getMessage());
			return model(model,false,e.getMessage());
		}
		return model(model,true,"");
	}

	/**
	 * 上传文件格式、内容校验
	 * 
	 * @param httpServletRequest
	 * @param type
	 * @return
	 */
	private Boolean checkIsLegal(HttpServletRequest httpServletRequest, String type) {
		MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) httpServletRequest;
		MultipartFile requestFile = multipartRequest.getFile("file");
		String originalFilename = requestFile.getOriginalFilename();
		if (!originalFilename.endsWith(ExcelTypeEnum.XLS.getValue())
				&& !originalFilename.endsWith(ExcelTypeEnum.XLSX.getValue())) {
			logger.error("Excel导入错误文件名称：{}", originalFilename);
			return false;
		} else {
			if (!originalFilename.contains(type)) {
				logger.error("导入的不是非空性校验规则文件：{}", originalFilename);
				return false;
			}
		}
		return true;
	}

}
