package com.gmei.data.dqmp.controller;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;

import com.gmei.data.dqmp.service.DqRuleService;
import com.gmei.data.dqmp.vo.DqReferRuleVo;
import com.gmei.data.dqmp.vo.DqSpecialRuleVo;
import com.gmei.data.dqmp.vo.DqUnblankRuleVo;
import com.gmei.data.dqmp.vo.DqUniqueRuleVo;
import com.gmei.data.dqmp.vo.DqVolatilityRuleVo;

@Controller
public class IndexController {

	@Autowired
	private DqRuleService dqRuleService;
    /**
     * 首页中功能列表
     * @param model
     * @return
     */
    @GetMapping("/")
    public String index(Model model) {
    	List<DqUniqueRuleVo> uniqueList = dqRuleService.findUniqueDqRuleList();
    	List<DqUnblankRuleVo> unblankList = dqRuleService.findUnblankDqRuleList();
    	List<DqReferRuleVo> referList = dqRuleService.findReferDqRuleList();
    	List<DqVolatilityRuleVo> volatilityList = dqRuleService.findVolatilityDqRuleList();
    	List<DqSpecialRuleVo> specialList = dqRuleService.findSpecialDqRuleList();
        model.addAttribute("uniqueList", uniqueList);
        model.addAttribute("unblankList", unblankList);
        model.addAttribute("referList", referList);
        model.addAttribute("volatilityList", volatilityList);
        model.addAttribute("specialList", specialList);
        return "index";
    }
    
}
