package com.gmei.data.dqmp.controller;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import com.gmei.data.dqmp.dto.RuleTemplateDto;
import com.gmei.data.dqmp.service.RuleTemplateService;
import com.gmei.data.dqmp.vo.RuleTemplateVo;

@RestController
@RequestMapping(value = "/ruleTemplate")
public class RuleTemplateController {
	
	@Autowired
    private RuleTemplateService ruleTemplateService;

	@ResponseBody
    @RequestMapping(value = "/find", method = RequestMethod.POST)
    public RuleTemplateVo findRuleTmpls(@RequestBody RuleTemplateVo ruleTemplateVo) {
    	List<RuleTemplateDto> findRuleTmpls = ruleTemplateService.findRuleTmpls(ruleTemplateVo.getCheckType());
        return new RuleTemplateVo(findRuleTmpls);
    }
	
	@ResponseBody
    @RequestMapping(value = "/add", method = RequestMethod.POST)
    public RuleTemplateVo addRuleTmpls(@RequestBody RuleTemplateVo ruleTemplateVo) {
    	Integer rs = ruleTemplateService.addRuleTmpl(ruleTemplateVo);
    	if(rs == 1) {
    		return new RuleTemplateVo();
    	}else {
    		return new RuleTemplateVo(-1,"add failed!");
    	}
        
    }
}
