package com.gmei.data.dqmp.controller.api;

import javax.validation.Valid;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import com.gmei.data.dqmp.service.DqRuleService;
import com.gmei.data.dqmp.vo.DqRuleVo;

@RestController
@RequestMapping(value = "/api/dqrule")
public class DqRuleApiController {

	@Autowired
	private DqRuleService dqRuleService;
	
	/**
	 * 校验规则新增
	 * @param dqRuleVo
	 * @param bindingResult
	 * @return
	 */
	@ResponseBody
    @RequestMapping(value = "/add", method = RequestMethod.POST)
    public DqRuleVo addDqRule(@RequestBody @Valid DqRuleVo dqRuleVo,BindingResult bindingResult) {
		if (bindingResult.hasErrors()) {
            return new DqRuleVo(-1,bindingResult.getFieldError().getDefaultMessage());
        }
		Boolean isAddSuc = dqRuleService.addDqRule(dqRuleVo);
		if(isAddSuc) {
			return new DqRuleVo();
		}else {
			return new DqRuleVo(-1,"Rule add error!");
		}
    }
}
