package com.gmei.data.dqmp.listener;

import java.util.ArrayList;
import java.util.List;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.gmei.data.dqmp.service.DqRuleService;
import com.gmei.data.dqmp.vo.DqRuleVo;

public class VolatilityExcelListener extends AnalysisEventListener<Object> {
 
	private DqRuleService dqRuleService;
 
    public VolatilityExcelListener(DqRuleService dqRuleService) {
        super();
        this.dqRuleService = dqRuleService;
    }
 
    private List<Object>  data = new ArrayList<>();
 
    @Override
    public void invoke(Object object, AnalysisContext context) {
        System.out.println(context.getCurrentSheet());
        data.add(object);
        if(data.size()>=100){
            doSomething();
            data.clear();
        }
    }
 
    @Override
    public void doAfterAllAnalysed(AnalysisContext context) {
        doSomething();
    }
 
    public void doSomething(){
        for (Object o:data) {
            String jsonString = JSONObject.toJSONString(o);
            JSONObject jsonObject = JSONObject.parseObject(jsonString);
            DqRuleVo dqRuleVo = JSON.toJavaObject(jsonObject, DqRuleVo.class);
            dqRuleService.addDqRule(dqRuleVo);
        }
    }
 
    public List<Object> getData() {
        return data;
    }
 
    public void setData(List<Object> data) {
        this.data = data;
    }
}
