package com.gmei.data.dqmp.pool;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Properties;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcConnectPool {

	private static final Logger logger = LoggerFactory.getLogger(JdbcConnectPool.class);
	private static Properties prop;
	private static int currentsize = 0;
	private static LinkedList<Connection> connList = new LinkedList<Connection>();

	static {
		prop = getProperties("jdbc.properties");
		try {
			Class.forName(prop.getProperty("driverClassName"));
		} catch (ClassNotFoundException e) {
			e.printStackTrace();
		}
		for (int i = 0; i < Integer.valueOf(prop.getProperty("initSize")); i++) {
			Connection connection = createConnect();
			connList.add(connection);
			currentsize++;
		}
	}

	/**
	 * 获取连接
	 * 
	 * @return
	 */
	public static Connection getConnect() {
		Connection connection = null;
		if (connList.size() > 0) {
			connection = connList.getFirst();
			connList.removeFirst();
		} else if (connList.size() == 0 && currentsize < Integer.valueOf(prop.getProperty("maxSize"))) {
			connList.addLast(createConnect());
			connection = connList.getFirst();
			connList.removeFirst();
			currentsize++;
		}
		logger.info("Current pool size : {}",currentsize);
		return connection;
	}

	/**
	 * 创建连接
	 * 
	 * @return
	 */
	private static Connection createConnect() {
		Connection conn = null;
		try {
			conn = DriverManager.getConnection(prop.getProperty("url"), prop.getProperty("username"),
					prop.getProperty("password"));
		} catch (SQLException e) {
			e.printStackTrace();
		}
		return conn;
	}

	/**
	 * 释放连接
	 * 
	 * @param connection
	 */
	public static void releaseConnection(Connection connection) {
		connList.addLast(connection);
	}

	/**
	 * 获取属性文件对象
	 * 
	 * @param path
	 * @return
	 */
	private static Properties getProperties(String path) {
		Properties properties = new Properties();
		try {
			InputStream inputStream = JdbcConnectPool.class.getClassLoader().getResourceAsStream(path);
			properties.load(inputStream);
			inputStream.close();
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return properties;
	}
}
