package com.gmei.data.dqmp.scheduler;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import com.gmei.data.dqmp.common.Constants;
import com.gmei.data.dqmp.service.CheckService;
import com.gmei.data.dqmp.service.MonitorService;

@Component
public class DqScheduler {
	
	@Autowired
	private CheckService checkService;
	@Autowired
	private MonitorService monitorService;
	
    @Scheduled(cron="0 */100 * * * ?")
    private void uniqueCheckProcess(){
    	checkService.checkAndPersistSimpleResult(Constants.CHECK_UNIQUE);
    }
    
    @Scheduled(cron="10 */100 * * * ?")
    private void unblankCheckProcess(){
    	checkService.checkAndPersistSimpleResult(Constants.CHECK_UNBLANK);
    }
    
    @Scheduled(cron="0 */100 * * * ?")
    private void referCheckProcess(){
    	checkService.checkAndPersistMultipleResult(Constants.CHECK_REFER);
    }
    
    @Scheduled(cron="0 */100 * * * ?")
    private void volatilityMonitorProcess(){
    	monitorService.monitorAndPersistVolatilityResult(Constants.MONITOR_PV);
    }
    
    @Scheduled(cron="0 */100 * * * ?")
    private void specialMonitorProcess(){
    	monitorService.monitorAndPersistSpecialResult();
    }
}
