package com.gmei.data.dqmp.service.impl;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import com.alibaba.fastjson.JSONObject;
import com.gmei.data.dqmp.domain.TblClientVersionInfo;
import com.gmei.data.dqmp.domain.TblClientVersionInfoCriteria;
import com.gmei.data.dqmp.mapper.TblClientVersionInfoMapper;
import com.gmei.data.dqmp.service.ClientInfoService;
import com.gmei.data.dqmp.utils.DateUtils;

@Service
public class ClientInfoServiceImpl implements ClientInfoService {
	
	@Autowired
	private TblClientVersionInfoMapper tblClientVersionInfoMapper;

	@Override
	public void getAndPersistClientInfo() {
		List<TblClientVersionInfo> list = new ArrayList<>();
		list.add(getAndroidInfo());
		list.add(getIosInfo());
		for(TblClientVersionInfo tblClientVersionInfo : list) {
			TblClientVersionInfoCriteria example = new TblClientVersionInfoCriteria();
			example.createCriteria()
				.andClTypeEqualTo(tblClientVersionInfo.getClType())
				.andClVersionEqualTo(tblClientVersionInfo.getClVersion())
				.andPartitionDateEqualTo(DateUtils.getCurrentDateStr());
			List<TblClientVersionInfo> rsList = tblClientVersionInfoMapper.selectByExample(example);
			if(null != rsList && rsList.size() == 0) {
				tblClientVersionInfoMapper.insert(tblClientVersionInfo);
			}
		}
	}
	
	/**
     * 根据url获取android客户端版本信息
     * @return
     */
    private TblClientVersionInfo getAndroidInfo(){
    	TblClientVersionInfo tblClientVersionInfo = new TblClientVersionInfo();
    	String html = getHtmlContent("https://sj.qq.com/myapp/detail.htm?apkName=com.wanmeizhensuo.zhensuo");
        Document doc = Jsoup.parse(html);
        String version = doc.getElementsByClass("det-othinfo-data").get(0).text();
        version = version.substring(1);
        Elements elementsByAttribute = doc.getElementsByAttribute("data-apkPublishTime");
        Element element = elementsByAttribute.get(0);
        Attributes attributes = element.attributes();
        String updateTime = attributes.asList().get(2).getValue();
        String date = new SimpleDateFormat("yyyy-MM-dd HH:mm").format(new Date(Long.valueOf(updateTime)*1000));
        tblClientVersionInfo.setClType("Android");
		tblClientVersionInfo.setClVersion(version);
		tblClientVersionInfo.setVersionTime(date);
		tblClientVersionInfo.setCreateTime(DateUtils.getCurrentTimeStr());
		tblClientVersionInfo.setPartitionDate(DateUtils.getCurrentDateStr());
        return tblClientVersionInfo;
    }
    
    /**
     * 根据url获取页面元素
     * @param androidUrl
     * @return
     */
    private String getHtmlContent(String androidUrl) {
    	String[] cmds = {"curl","-u", "admin:admin",  "-XGET", androidUrl,"-H"
    	        ,"X-Requested-By:sdc"};
    	ProcessBuilder process = new ProcessBuilder(cmds);
        Process p;
        String html = "";
        try {
            p = process.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            StringBuilder builder = new StringBuilder();
            String line = null;
            while ((line = reader.readLine()) != null) {
                builder.append(line);
                builder.append(System.getProperty("line.separator"));
            }
            html = builder.toString();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return html;
    }
    
    /**
     * 获取ios客户端信息
     * @return
     */
    private TblClientVersionInfo getIosInfo() {
    	TblClientVersionInfo tblClientVersionInfo = new TblClientVersionInfo();
        String urlStr = "http://itunes.apple.com/lookup?id=639234809";
        String res=null;
        try {
            URL url = new URL(urlStr);  
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();  
            conn.setConnectTimeout(3*1000);
            //防止屏蔽程序抓取而返回403错误
            conn.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
            InputStream inputStream = conn.getInputStream();  
            res = readInputStream(inputStream);
        } catch (Exception e) {
        	System.out.println("Get content by url exception：" + e);
        }
        JSONObject parseObject = JSONObject.parseObject(res); 
		JSONObject jsonObject = parseObject.getJSONArray("results").getJSONObject(0); 
		String version = jsonObject.getString("version"); 
		String date=jsonObject.getString("currentVersionReleaseDate");
		tblClientVersionInfo.setClType("IOS");
		tblClientVersionInfo.setClVersion(version);
		tblClientVersionInfo.setVersionTime(dealDateFormat(date));
		tblClientVersionInfo.setCreateTime(DateUtils.getCurrentTimeStr());
		tblClientVersionInfo.setPartitionDate(DateUtils.getCurrentDateStr());
        return tblClientVersionInfo;
    }
    
    /**
     * 读取输入流字符串
     * @param inputStream
     * @return
     * @throws IOException
     */
    public static String readInputStream(InputStream inputStream) throws IOException {  
    	String rs = "";
    	try {
    		byte[] buffer = new byte[1024];  
	        int len = 0;  
	        ByteArrayOutputStream bos = new ByteArrayOutputStream();  
	        while((len = inputStream.read(buffer)) != -1) {  
	            bos.write(buffer, 0, len);  
	        }  
	        bos.close();  
	        rs = new String(bos.toByteArray(),"utf-8");
    	}catch(Exception e) {
    		e.printStackTrace();
    	}
        return rs;
    } 
    
    /**
     * 日期转换
     * @param oldDateStr
     * @return
     */
    public static String dealDateFormat(String oldDateStr){
    	String rs = "";
    	try {
    		DateFormat df1 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
      	  	Date  date = df1.parse(oldDateStr);
      	  	DateFormat df2 = new SimpleDateFormat("yyyy-MM-dd HH:mm");
      	  	rs = df2.format(date);
	    	}catch (Exception e) {
	    		e.printStackTrace();
	    	}
    	return rs;
    }
	
}
