package com.gmei.data.dqmp.service.impl;

import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.gmei.data.dqmp.service.DingdingService;

@Service
public class DingdingServiceImpl implements DingdingService {

	@Value("${dingding.webhookToken}")
    private String webhookToken;
	@Value("${dingding.atMobile}")
	private String atMobile;
	private static final Logger logger = LoggerFactory.getLogger(DingdingServiceImpl.class);
	
	/**
     * 发送钉钉消息
     *
     * @param jsonObject
     * @throws Exception
     */
	@Override
    public Boolean sendMsgToDingding(String msg) {
    	JSONObject jsonObject = new JSONObject();
        jsonObject.put("msgtype", "text");
        JSONObject jo = new JSONObject();
        jo.put("content", msg);
        jsonObject.put("text", jo);
        JSONObject joo = new JSONObject();
        JSONArray ja = new JSONArray();
        ja.add(atMobile);
        joo.put("atMobiles", ja);
        joo.put("isAtAll", false);
        jsonObject.put("at", joo);
        Boolean rs = false;
        try {
            HttpClient httpclient = HttpClients.createDefault();
            HttpPost httppost = new HttpPost(webhookToken);
            httppost.addHeader("Content-Type", "application/json; charset=utf-8");
            String str = jsonObject.toString();
            logger.info(str);
            StringEntity se = new StringEntity(str, "utf-8");
            httppost.setEntity(se);
            HttpResponse response = httpclient.execute(httppost);
            if (response.getStatusLine().getStatusCode() == HttpStatus.SC_OK) {
                String result = EntityUtils.toString(response.getEntity(), "utf-8");
                logger.info(result);
            }
            rs = true;
        } catch (Exception e) {
        	logger.error(e.getMessage());
            e.printStackTrace();
        }
        return rs;
    }
}
