package com.gmei.data.dqmp.service.impl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import com.gmei.data.dqmp.service.FormatService;

public class FormatServiceImpl implements FormatService {

	/**
	 * 将字符串中的多个空格、换行符、回车符、制表符转为单个空格
	 * @param str
	 * @return
	 */
	@Override
	public String removeNewlineSymbol(String str) {
		String dest = "";
		if (str!=null) {
			Pattern p = Pattern.compile("\\s{1,}|\t|\r|\n");
			Matcher m = p.matcher(str);
			dest = m.replaceAll(" ");
			
		}
		return dest;
	}
	
	public static void main(String[] args) {
		String removeNewlineSymbol = new FormatServiceImpl().removeNewlineSymbol("SELECT '$db_name' AS DB_NAME,\n" + 
				"	       '$tb_name' AS TB_NAME,\n" + 
				"	       '$time_col_name' AS TIME_COL_NAME,\n" + 
				"	       '$start_time' AS START_TIME,\n" + 
				"	       '$end_time' AS END_TIME,\n" + 
				"	       COUNT(*) AS COUNT_NUM,\n" + 
				"       	   DATE_ADD(from_unixtime(unix_timestamp(), 'yyyy-MM-dd'), -1) AS PARTITION_DATE,\n" + 
				"           FROM_UNIXTIME(unix_timestamp(), 'yyyy-MM-dd HH:mm:ss') AS CREATE_TIME\n" + 
				"	  FROM $db_name.$tb_name\n" + 
				"	 WHERE $time_col_name >= $start_time\n" + 
				"	   AND $time_col_name < $end_time\n" + 
				"	 $filters");
		System.out.println(removeNewlineSymbol);
	}
}
