package com.gmei.data.dqmp.service.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.gmei.data.dqmp.common.Constants;
import com.gmei.data.dqmp.domain.TblResultMonitorSpecial;
import com.gmei.data.dqmp.domain.TblResultMonitorVolatility;
import com.gmei.data.dqmp.domain.TblSqlMonitorSpecial;
import com.gmei.data.dqmp.domain.TblSqlMonitorSpecialCriteria;
import com.gmei.data.dqmp.domain.TblSqlMonitorVolatility;
import com.gmei.data.dqmp.domain.TblSqlMonitorVolatilityCriteria;
import com.gmei.data.dqmp.mapper.TblResultMonitorSpecialMapper;
import com.gmei.data.dqmp.mapper.TblResultMonitorVolatilityMapper;
import com.gmei.data.dqmp.mapper.TblSqlMonitorSpecialMapper;
import com.gmei.data.dqmp.mapper.TblSqlMonitorVolatilityMapper;
import com.gmei.data.dqmp.pool.JdbcConnectPool;
import com.gmei.data.dqmp.service.DingdingService;
import com.gmei.data.dqmp.service.MailService;
import com.gmei.data.dqmp.service.MonitorService;
import com.gmei.data.dqmp.utils.DateUtils;

@Service
public class MonitorServiceImpl implements MonitorService {

	private static final Logger logger = LoggerFactory.getLogger(MonitorServiceImpl.class);

	@Autowired
	private TblSqlMonitorVolatilityMapper tblSqlMonitorVolatilityMapper;
	@Autowired
	private TblSqlMonitorSpecialMapper tblSqlMonitorSpecialMapper;
	@Autowired
	private TblResultMonitorVolatilityMapper tblResultMonitorVolatilityMapper;
	@Autowired
	private TblResultMonitorSpecialMapper tblResultMonitorSpecialMapper;
	@Autowired
	private MailService mailService;
	@Autowired
	private DingdingService dingdingService;

	/**
	 * 监控并持久化波动型监控结果
	 * 
	 * @param indicatorType
	 */
	@Override
	public void monitorAndPersistVolatilityResult(String indicatorType) {
		TblSqlMonitorVolatilityCriteria tblmonitorVolatilitySqlCriteria = new TblSqlMonitorVolatilityCriteria();
		tblmonitorVolatilitySqlCriteria.createCriteria().andIndicatorTypeEqualTo(indicatorType).andIsValidEqualTo(Constants.IS_VALID_ON);
		List<TblSqlMonitorVolatility> sqlList = tblSqlMonitorVolatilityMapper
				.selectByExampleWithBLOBs(tblmonitorVolatilitySqlCriteria);
		for (TblSqlMonitorVolatility tblCheckSql : sqlList) {
			String sql = tblCheckSql.getSqlContent();
			Integer id = tblCheckSql.getId();
			Double threshold = tblCheckSql.getThreshold();
			int rs = 0;
			TblResultMonitorVolatility tblResultMonitorVolatility = getMonitorVolatilityResult(sql, indicatorType);
			if (tblResultMonitorVolatility == null) {
				logger.error("Find result is empty!");
				return;
			}else {
				Long indicatorValue = tblResultMonitorVolatility.getIndicatorValue();
				if(indicatorValue <= threshold) {
					mailService.sendSimpleMail(tblResultMonitorVolatility.toString());
					dingdingService.sendMsgToDingding(tblResultMonitorVolatility.toString());
				}
			}
			tblResultMonitorVolatility.setSqlId(id);
			rs = tblResultMonitorVolatilityMapper.insert(tblResultMonitorVolatility);
			if (rs == 1) {
				logger.info("Run success: {}", sql);
			} else {
				logger.error("Run failed: {}", sql);
			}
		}
	}
	
	/**
	 * 监控并持久化特殊型监控结果
	 * 
	 */
	@Override
	public void monitorAndPersistSpecialResult() {
		TblSqlMonitorSpecialCriteria tblMonitorSpecialSqlCriteria = new TblSqlMonitorSpecialCriteria();
		tblMonitorSpecialSqlCriteria.createCriteria().andIsValidEqualTo(Constants.IS_VALID_ON);
		List<TblSqlMonitorSpecial> sqlList = tblSqlMonitorSpecialMapper.selectByExampleWithBLOBs(tblMonitorSpecialSqlCriteria);
		for (TblSqlMonitorSpecial tblCheckSql : sqlList) {
			String sql = tblCheckSql.getSqlContent();
			Integer id = tblCheckSql.getId();
			Double threshold = tblCheckSql.getThreshold();
			int rs = 0;
			TblResultMonitorSpecial tblResultMonitorSpecial = getMonitorSpecialResult(sql);
			if (tblResultMonitorSpecial == null) {
				logger.error("Find result is empty!");
				return;
			}else {
				Long indicatorValue = tblResultMonitorSpecial.getIndicatorValue();
				if(indicatorValue <= threshold) {
					mailService.sendSimpleMail(tblResultMonitorSpecial.toString());
					dingdingService.sendMsgToDingding(tblResultMonitorSpecial.toString());
				}
			}
			tblResultMonitorSpecial.setSqlId(id);
			rs = tblResultMonitorSpecialMapper.insert(tblResultMonitorSpecial);
			if (rs == 1) {
				logger.info("Run success: {}", sql);
			} else {
				logger.error("Run failed: {}", sql);
			}
		}
	}

	/**
	 * 获取波动性校验结果
	 * 
	 * @param sql
	 * @return
	 */
	private TblResultMonitorVolatility getMonitorVolatilityResult(String sql, String indicatorType) {
		sql = sql.replaceAll("#partation_date", String.format("'%s'", DateUtils.getYesterdayDateStr()));
		logger.info("Sql content : {},indicatorType: {}", sql, indicatorType);
		TblResultMonitorVolatility tblResultMonitorVolatility = null;
		if (StringUtils.isBlank(sql) || StringUtils.isBlank(indicatorType)) {
			return tblResultMonitorVolatility;
		}
		try {
			Connection conn = JdbcConnectPool.getConnect();
			PreparedStatement ps = conn.prepareStatement(sql);
			ResultSet rs = ps.executeQuery();
			while (rs.next()) {
				tblResultMonitorVolatility = new TblResultMonitorVolatility();
				tblResultMonitorVolatility.setDbName(rs.getString("db_name"));
				tblResultMonitorVolatility.setTbName(rs.getString("tb_name"));
				tblResultMonitorVolatility.setColName(rs.getString("col_name"));
				tblResultMonitorVolatility.setIndicatorType(rs.getString("indicator_type"));
				tblResultMonitorVolatility.setIndicatorValue(rs.getLong("indicator_value"));
				tblResultMonitorVolatility.setPartitionDate(rs.getString("partition_date"));
				tblResultMonitorVolatility.setCreateTime(rs.getString("create_time"));
			}
			rs.close();
			ps.close();
			JdbcConnectPool.releaseConnection(conn);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return tblResultMonitorVolatility;
	}
	
	/**
	 * 获取特殊性校验结果
	 * 
	 * @param sql
	 * @return
	 */
	private TblResultMonitorSpecial getMonitorSpecialResult(String sql) {
		sql = sql.replaceAll("#partation_date", String.format("'%s'", DateUtils.getYesterdayDateStr()));
		logger.info("Sql content : {}", sql);
		TblResultMonitorSpecial tblResultMonitorSpecial = null;
		if (StringUtils.isBlank(sql)) {
			return tblResultMonitorSpecial;
		}
		try {
			Connection conn = JdbcConnectPool.getConnect();
			PreparedStatement ps = conn.prepareStatement(sql);
			ResultSet rs = ps.executeQuery();
			while (rs.next()) {
				tblResultMonitorSpecial = new TblResultMonitorSpecial();
				tblResultMonitorSpecial.setDbName(rs.getString("db_name"));
				tblResultMonitorSpecial.setTbName(rs.getString("tb_name"));
				tblResultMonitorSpecial.setTimeColName(rs.getString("time_col_name"));
				tblResultMonitorSpecial.setStartTime(rs.getString("start_time"));
				tblResultMonitorSpecial.setIndicatorType(rs.getString("indicator_type"));
				tblResultMonitorSpecial.setIndicatorValue(rs.getLong("indicator_value"));
				tblResultMonitorSpecial.setPartitionDate(rs.getString("partition_date"));
				tblResultMonitorSpecial.setCreateTime(rs.getString("create_time"));
			}
			rs.close();
			ps.close();
			JdbcConnectPool.releaseConnection(conn);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return tblResultMonitorSpecial;
	}
}
