package com.gmei.data.dqmp.service.impl;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.gmei.data.dqmp.domain.TblRuleTemplate;
import com.gmei.data.dqmp.domain.TblRuleTemplateCriteria;
import com.gmei.data.dqmp.dto.RuleTemplateDto;
import com.gmei.data.dqmp.mapper.TblRuleTemplateMapper;
import com.gmei.data.dqmp.service.RuleTemplateService;
import com.gmei.data.dqmp.utils.BeanUtils;
import com.gmei.data.dqmp.vo.RuleTemplateVo;

@Service
public class RuleTemplateServiceImpl implements RuleTemplateService {
	
	@Autowired
    private TblRuleTemplateMapper tblRuleTemplateMapper;

	@Override
	public List<RuleTemplateDto> findRuleTmpls(String checkType) {
		List<RuleTemplateDto> rsList = new ArrayList<>();
		TblRuleTemplateCriteria tblDqRuleTemplateCriteria = new TblRuleTemplateCriteria();
		if(StringUtils.isNotBlank(checkType)) {
			tblDqRuleTemplateCriteria.createCriteria().andCheckTypeEqualTo(checkType);
		}
		List<TblRuleTemplate> list = tblRuleTemplateMapper.selectByExampleWithBLOBs(tblDqRuleTemplateCriteria);
		for(TblRuleTemplate tblDqRuleTemplate : list) {
			rsList.add(BeanUtils.map(tblDqRuleTemplate, RuleTemplateDto.class));
		}
		return rsList;
	}

	@Override
	@Transactional
	public Integer addRuleTmpl(RuleTemplateVo ruleTemplateVo) {
		TblRuleTemplate tblDqRuleTemplate = BeanUtils.map(ruleTemplateVo, TblRuleTemplate.class);
		int insertSelective = tblRuleTemplateMapper.insertSelective(tblDqRuleTemplate);
		return insertSelective;
	}
	
}
