package com.gmei.data.dqmp.service.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;

import com.gmei.data.dqmp.domain.TblSysParamInfo;
import com.gmei.data.dqmp.domain.TblSysParamInfoCriteria;
import com.gmei.data.dqmp.mapper.TblSysParamInfoMapper;
import com.gmei.data.dqmp.service.TblSysParamInfoService;

public class TblSysParamInfoServiceImpl implements TblSysParamInfoService {

	@Autowired
	private TblSysParamInfoMapper tblSysParamInfoMapper;
	
	@Override
	public Map<String,String> getSysParamMap(String paramType){
		Map<String,String> rsMap = new HashMap<String, String>();
		TblSysParamInfoCriteria example = new TblSysParamInfoCriteria();
		example.createCriteria().andParamTypeEqualTo(paramType);
		List<TblSysParamInfo> rsList = tblSysParamInfoMapper.selectByExample(example);
		for(TblSysParamInfo tblSysParamInfo : rsList) {
			rsMap.put(tblSysParamInfo.getParamKey(), tblSysParamInfo.getParamValue());
		}
		return rsMap;
	}
}
