package com.gmei.data.dqmp.utils;

import org.dozer.*;

/**
 * ClassName: BeanMapper
 * Date: 2019/7/22 下午3:46
 *
 * @author zhaojianwei
 * @since JDK 1.8
 */
public final class BeanUtils {

    private static Mapper mapper;

    public static void map(final Object source, final Object destination) {
        BeanUtils.mapper.map(source, destination);
    }

    @SuppressWarnings({ "rawtypes", "unchecked" })
	public static <T> T map(final Object source, final Class<T> destinationClass) {
        return (T)BeanUtils.mapper.map(source, (Class)destinationClass);
    }

    @SuppressWarnings({ "unchecked", "rawtypes" })
	public static <T> T map(final Object source, final Class<T> destinationClass, final String mapId) {
        return (T)BeanUtils.mapper.map(source, (Class)destinationClass, mapId);
    }

    public static void map(final Object source, final Object destination, final String mapId) {
        BeanUtils.mapper.map(source, destination, mapId);
    }

    static {
        BeanUtils.mapper = (Mapper)new DozerBeanMapper();
        final Mapper bean = SpringUtils.getBean(Mapper.class);
        if (bean != null) {
            BeanUtils.mapper = bean;
        }
    }
}
