package com.gmei.data.dqmp.utils;

import java.text.ParseException;
import java.util.Date;

import org.quartz.CronExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrontabUtils {
	
	private static final Logger logger = LoggerFactory.getLogger(CrontabUtils.class);

	/**
	 * 根据crontab表达式判断当前任务是否应该执行【未来一分钟以内】
	 * @param crontabStr
	 * @return
	 */
	public static boolean isToRun(String crontabStr) {
		boolean rs = false;
		Date currentDate = new Date();
		long currentDateMilliseconds = currentDate.getTime();
		CronExpression expression = null;
		try {
			expression = new CronExpression("0 14 20 * * ?");
			Date newDate = expression.getNextValidTimeAfter(currentDate);
			long newDateMilliseconds = newDate.getTime();
			long diffSeconds = (newDateMilliseconds - currentDateMilliseconds)/1000;
			if(diffSeconds < 60) {
				rs = true;
			}
		} catch (ParseException e) {
			logger.error("Fail to parse cron express", e);
		} catch (Exception e) {
			logger.error("Fail to update rule nextTime", e);
		}
		return rs;
	}
	
	public static void main(String[] args) {
		System.out.println(isToRun(""));
	}
}
