package com.gmei.data.dqmp.utils;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;

public class DateUtils {
	
	private static final String DATE_FORMATE_YMD = "yyyy-MM-dd";
	private static final String PARTITION_DATE_FORMAT = "yyyyMMdd";
	private static final String DATE_FORMATE_YMDHMS = "yyyy-MM-dd HH:mm:ss";
	private static final String DATE_FORMATE_YMDHMSS = "yyyy-MM-dd HH:mm:ss.S";
	
	/**
	 * 获取当前时间字符串
	 * @return
	 */
	public static String getCurrentDateStr() {
    	return new SimpleDateFormat(DATE_FORMATE_YMD).format(new Date());
    }
	
	/**
	 * 获取当前时间字符串
	 * @return
	 */
	public static String getCurrentTimeStr() {
		return new SimpleDateFormat(DATE_FORMATE_YMDHMS).format(new Date());
	}
	
	/**
	 * 获取昨天时间字符串
	 * @return
	 */
	public static String getYesterdayDateStr() {
		Calendar cld = Calendar.getInstance();
		cld.setTime(new Date());
		cld.add(Calendar.DAY_OF_MONTH, -1);
		return new SimpleDateFormat(PARTITION_DATE_FORMAT).format(cld.getTime());
	}
	
	/**
	 * 获取今天0时0分0秒0毫秒时间字符串
	 * @return
	 */
	public static String getTodayZeroTimeStr() {
		Calendar cld = Calendar.getInstance();
		cld.setTime(new Date());
		cld.set(Calendar.HOUR_OF_DAY, 0);
		cld.set(Calendar.MINUTE, 0);
		cld.set(Calendar.SECOND, 0);
		cld.set(Calendar.MILLISECOND, 0);
		return new SimpleDateFormat(DATE_FORMATE_YMDHMSS).format(cld.getTime());
	}
	
	/**
	 * 根据时间类型，获取当天0时0分0秒0毫秒时间字符串
	 * 
	 * @return
	 */
	public static String getZeroTimeStrByTimeType(String timeType) {
		Calendar cld = Calendar.getInstance();
		cld.setTime(new Date());
		switch (timeType) {
		case "0":
			cld.add(Calendar.DAY_OF_MONTH, -1);
			break;
		case "1":
			cld.add(Calendar.DAY_OF_MONTH, -2);
			break;
		case "2":
			cld.add(Calendar.DAY_OF_MONTH, -3);
			break;
		case "3":
			cld.add(Calendar.DAY_OF_MONTH, -7);
			break;
		case "4":
			cld.add(Calendar.DAY_OF_MONTH, -30);
			break;
		default:
			cld.add(Calendar.DAY_OF_MONTH, -1);
		}
		cld.set(Calendar.HOUR_OF_DAY, 0);
		cld.set(Calendar.MINUTE, 0);
		cld.set(Calendar.SECOND, 0);
		cld.set(Calendar.MILLISECOND, 0);
		return new SimpleDateFormat(DATE_FORMATE_YMDHMSS).format(cld.getTime());
	}
	
	public static Map<String,String> getZeroTimeStrsMap(){
		Map<String,String> map = new HashMap<>();
		String[] array = {"0","1","2","3","4"};
		for(String timeType : Arrays.asList(array)) {
			map.put(timeType, getZeroTimeStrByTimeType(timeType));
		}
		return map;
	}
	
	public static void main(String[] args) {
		Map<String, String> zeroTimeStrsMap = getZeroTimeStrsMap();
		for(Entry<String, String> entry : zeroTimeStrsMap.entrySet()) {
			System.out.println(entry.getKey() + "---" + entry.getValue());
		}
	}
}
