package com.gmei.data.dqmp.utils;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.metadata.Sheet;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.gmei.data.dqmp.dto.DqReferRuleDto;
import com.gmei.data.dqmp.dto.DqSpecialRuleDto;
import com.gmei.data.dqmp.dto.DqUnblankRuleDto;
import com.gmei.data.dqmp.dto.DqUniqueRuleDto;
import com.gmei.data.dqmp.dto.DqVolatilityRuleDto;
import com.gmei.data.dqmp.listener.ReferExcelListener;
import com.gmei.data.dqmp.listener.SpecialExcelListener;
import com.gmei.data.dqmp.listener.UnblankExcelListener;
import com.gmei.data.dqmp.listener.UniqueExcelListener;
import com.gmei.data.dqmp.listener.VolatilityExcelListener;
import com.gmei.data.dqmp.service.DqRuleService;

public class ImportExcelUtils {

	private static final Logger logger = LoggerFactory.getLogger(ImportExcelUtils.class);

	public static void saxReadUniqueListString(HttpServletRequest request, DqRuleService dqRuleService) throws IOException {
		MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
		MultipartFile requestFile = multipartRequest.getFile("file");
		String originalFilename = requestFile.getOriginalFilename();
		if (!originalFilename.endsWith(ExcelTypeEnum.XLS.getValue())
				&& !originalFilename.endsWith(ExcelTypeEnum.XLSX.getValue())) {
			logger.error("Excel导入错误文件名称：{}", originalFilename);
			throw new RuntimeException("不是Excel格式文件");
		}
		InputStream inputStream = null;
		try {
			inputStream = requestFile.getInputStream();
			if (inputStream == null) {
				return;
			}
			BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
			AnalysisEventListener<?> excelListener = new UniqueExcelListener(dqRuleService);
			EasyExcelFactory.readBySax(bufferedInputStream, new Sheet(1, 1, DqUniqueRuleDto.class), excelListener);
		} finally {
			inputStream.close();
		}
	}
	public static void saxReadUnblankListString(HttpServletRequest request, DqRuleService dqRuleService) throws IOException {
		MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
		MultipartFile requestFile = multipartRequest.getFile("file");
		String originalFilename = requestFile.getOriginalFilename();
		if (!originalFilename.endsWith(ExcelTypeEnum.XLS.getValue())
				&& !originalFilename.endsWith(ExcelTypeEnum.XLSX.getValue())) {
			logger.error("Excel导入错误文件名称：{}", originalFilename);
			throw new RuntimeException("不是Excel格式文件");
		}
		InputStream inputStream = null;
		try {
			inputStream = requestFile.getInputStream();
			if (inputStream == null) {
				return;
			}
			BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
			AnalysisEventListener<?> excelListener = new UnblankExcelListener(dqRuleService);
			EasyExcelFactory.readBySax(bufferedInputStream, new Sheet(1, 1, DqUnblankRuleDto.class), excelListener);
		} finally {
			inputStream.close();
		}
	}
	public static void saxReadReferListString(HttpServletRequest request, DqRuleService dqRuleService) throws IOException {
		MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
		MultipartFile requestFile = multipartRequest.getFile("file");
		String originalFilename = requestFile.getOriginalFilename();
		if (!originalFilename.endsWith(ExcelTypeEnum.XLS.getValue())
				&& !originalFilename.endsWith(ExcelTypeEnum.XLSX.getValue())) {
			logger.error("Excel导入错误文件名称：{}", originalFilename);
			throw new RuntimeException("不是Excel格式文件");
		}
		InputStream inputStream = null;
		try {
			inputStream = requestFile.getInputStream();
			if (inputStream == null) {
				return;
			}
			BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
			AnalysisEventListener<?> excelListener = new ReferExcelListener(dqRuleService);
			EasyExcelFactory.readBySax(bufferedInputStream, new Sheet(1, 1, DqReferRuleDto.class), excelListener);
		} finally {
			inputStream.close();
		}
	}
	public static void saxReadVolatilityListString(HttpServletRequest request, DqRuleService dqRuleService) throws IOException {
		MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
		MultipartFile requestFile = multipartRequest.getFile("file");
		String originalFilename = requestFile.getOriginalFilename();
		if (!originalFilename.endsWith(ExcelTypeEnum.XLS.getValue())
				&& !originalFilename.endsWith(ExcelTypeEnum.XLSX.getValue())) {
			logger.error("Excel导入错误文件名称：{}", originalFilename);
			throw new RuntimeException("不是Excel格式文件");
		}
		InputStream inputStream = null;
		try {
			inputStream = requestFile.getInputStream();
			if (inputStream == null) {
				return;
			}
			BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
			AnalysisEventListener<?> excelListener = new VolatilityExcelListener(dqRuleService);
			EasyExcelFactory.readBySax(bufferedInputStream, new Sheet(1, 1, DqVolatilityRuleDto.class), excelListener);
		} finally {
			inputStream.close();
		}
	}
	public static void saxReadSpecialListString(HttpServletRequest request, DqRuleService dqRuleService) throws IOException {
		MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
		MultipartFile requestFile = multipartRequest.getFile("file");
		String originalFilename = requestFile.getOriginalFilename();
		if (!originalFilename.endsWith(ExcelTypeEnum.XLS.getValue())
				&& !originalFilename.endsWith(ExcelTypeEnum.XLSX.getValue())) {
			logger.error("Excel导入错误文件名称：{}", originalFilename);
			throw new RuntimeException("不是Excel格式文件");
		}
		InputStream inputStream = null;
		try {
			inputStream = requestFile.getInputStream();
			if (inputStream == null) {
				return;
			}
			BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
			AnalysisEventListener<?> excelListener = new SpecialExcelListener(dqRuleService);
			EasyExcelFactory.readBySax(bufferedInputStream, new Sheet(1, 1, DqSpecialRuleDto.class), excelListener);
		} finally {
			inputStream.close();
		}
	}
}
