package com.gmei.data.dqmp.utils;

import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
/**
 * ClassName: SpringUtils
 * Date: 2019/7/22 下午4:45
 *
 * @author zhaojianwei
 * @since JDK 1.8
 */
public final class SpringUtils implements ApplicationContextAware{

    private static ApplicationContext context;

    private static void setContext(final ApplicationContext context) {
        SpringUtils.context = context;
    }

    public void setApplicationContext(final ApplicationContext context) {
        setContext(context);
    }

    @SuppressWarnings("unchecked")
	public static <T> T getBean(final String name) {
        if (checkNull()) {
            return null;
        }
        return (T)SpringUtils.context.getBean(name);
    }

    @SuppressWarnings({ "unchecked", "rawtypes" })
	public static <T> T getBean(final Class<T> clz) {
        if (checkNull()) {
            return null;
        }
        return (T)SpringUtils.context.getBean((Class)clz);
    }

    @SuppressWarnings({ "unchecked", "rawtypes" })
	public static <T> T getBean(final String name, final Class<T> clz) {
        if (checkNull()) {
            return null;
        }
        return (T)SpringUtils.context.getBean(name, (Class)clz);
    }

    private static boolean checkNull() {
        if (SpringUtils.context == null) {
            return true;
        }
        return false;
    }

}
