--***************************************************************
--*脚本名称: create_pm_c_op_co_content_dimen_d.sql
--*功能: 内容日报
--*业务名称: pm
--*输入数据:
--*作者: weiyimin@igengmei.com
--*更新时间: 2020-5-25 11:00
--***************************************************************

--设置全局变量&UDF
SET mapreduce.job.queuename=data;

--使用bl数据库
USE pm;

--创建BL层内部表
CREATE TABLE IF NOT EXISTS pm.tl_pm_recommend_strategy_d
(
 day_id string comment '{"chs_name":"当天日期","description":"","etl":"","value":"","remark":""}',
 device_os_type string comment '{"chs_name":"设备类型","description":"","etl":"","value":"","remark":""}',
 active_type string comment '{"chs_name":"活跃类型","description":"","etl":"","value":"","remark":""}',
 card_content_type string comment '{"chs_name":"卡片类型","description":"","etl":"","value":"","remark":""}',
 recommend_type string comment '{"chs_name":"推荐类型","description":"","etl":"","value":"","remark":""}',
 card_click BIGINT comment '{"chs_name":"首页卡片点击PV","description":"","etl":"","value":"","remark":""}',
 card_exposure BIGINT comment '{"chs_name":"首页卡片精准曝光PV","description":"","etl":"","value":"","remark":""}',
 total_second_click BIGINT comment '{"chs_name":"来自首页卡片的总商业二跳pv（包含页面上搜索及卡片点击）","description":"","etl":"","value":"","remark":""}',
 avg_page_stay double comment '{"chs_name":"来自首页卡片的单PV平均浏览时长","description":"","etl":"","value":"","remark":""}',
 navbar_search BIGINT comment '{"chs_name":"来自首页卡片的搜索框+搜索按钮点击PV","description":"","etl":"","value":"","remark":""}',
 highlight_word BIGINT comment '{"chs_name":"来自首页卡片的文内搜索点击PV","description":"","etl":"","value":"","remark":""}',
 self_welfare_card BIGINT comment '{"chs_name":"来自首页卡片的商品卡片点击PV","description":"","etl":"","value":"","remark":""}',
 recommend_welfare_card BIGINT comment '{"chs_name":"来自首页卡片的推荐商品+查看全部商品点击pv","description":"","etl":"","value":"","remark":""}',
 recommend_content_card BIGINT comment '{"chs_name":"来自首页卡片的推荐内容点击pv","description":"","etl":"","value":"","remark":""}',
 recommend_special_card BIGINT comment '{"chs_name":"来自首页卡片的推荐专题点击pv","description":"","etl":"","value":"","remark":""}',
 transfer_card BIGINT comment '{"chs_name":"来自首页卡片的转诊点击pv","description":"","etl":"","value":"","remark":""}',
 video_consultation BIGINT comment '{"chs_name":"来自首页卡片的视频面诊点击pv","description":"","etl":"","value":"","remark":""}'
)comment '首页推荐策略日报'
PARTITIONED BY (PARTITION_DAY STRING comment '分区日期')
ROW FORMAT DELIMITED
FIELDS TERMINATED BY '\t'
COLLECTION ITEMS TERMINATED BY '\002'
MAP KEYS TERMINATED BY '\003'
LINES TERMINATED BY '\n'
STORED AS TEXTFILE;