#!/bin/bash

# 定义变量方便修改
#hive="/opt/spark/spark-2.4.5-bin-hadoop2.7/bin/beeline -u jdbc:hive2://bj-gm-prod-cos-datacenter003:10010 -n data"
hive="/opt/hive/hive-1.1.0-cdh5.16.1/bin/beeline -u jdbc:hive2://bj-gm-prod-cos-datacenter005:10000 -n data"

#至少输入一个参数 第一个参数为需求码(必选项)，第二个参数为分区日期(可选)
if [ $# -lt 1 ]; then
  echo "Param project_name lost, please check again!"
  exit 0
fi

#判断sql脚本是否存在
dir_name=$1
sql_path="/home/bi/bi-report/sqls/$dir_name/$dir_name.sql"
if [ ! -f $sql_path ]; then
  echo "Param project_name error, please check again!"
  exit 0
fi

# 如果是输入的日期按照取输入日期；如果没输入日期取当前时间的前一天
if [ -n "$2" ] ;then
  partition_date=$2
else
  partition_date=`date --date="-1 day" +%Y%m%d`
fi

#参数替换
tmp_sql=`cat ${sql_path}`
sql=${tmp_sql//'${partition_day}'/${partition_date}}
echo -e "${sql}"

#执行sql
$hive -e "$sql"