select
    t6.new_tag_name,                                      --新标签name
    t6.new_tag_type,                                      --新标签type
    t6.new_tag_id,                                        --新标签id
    t6.is_display,                                        --是否在app展示
    t6.is_online,                                         --是否生效
        collect_set(t6.jianyi_word) as jianyi_word,           --近义词
        collect_set(t6.like_new_tag) as tongyi_word,          --同义词
        collect_set(t6.fangshi_1f) as fangshi_1st,            --一级方式_name
        collect_set(t6.fangshi_2d) as fangshi_2nd,            --二级方式_name
        collect_set(t6.suqiu_1f) as suqiu_1st,                --一级诉求_name
        collect_set(t6.suqiu_2d) as suqiu_2nd,                --二级诉求_name
        collect_set(t6.buwei_if) as buwei_1st,                --一级部位_name
        collect_set(t6.buwei_2d) as buwei_2nd,                --二级部位_name
        collect_set(t6.old_tag_name) as old_tag_name,         --老标签_name
        collect_set(t6.old_tag_type) as old_tag_type,         --老标签_type
        collect_set(t6.old_tag_id) as old_tag_id,             --老标签_id
        collect_set(t6.fangshi_1f_id) as fangshi_1st_id,      --一级方式_id
        collect_set(t6.fangshi_2d_id) as fangshi_2nd_id,      --二级方式_id
        collect_set(t6.suqiu_1f_id) as suqiu_1st_id,          --一级诉求_id
        collect_set(t6.suqiu_2d_id) as suqiu_2nd_id,          --二级诉求_id
        collect_set(t6.buwei_if_id) as buwei_1st_id,          --一级部位_id
        collect_set(t6.buwei_2d_id) as buwei_2nd_id           --二级部位_id
from
    (
        select
            t1.name as new_tag_name,                                                       --新标签name
            t1.tag_type as new_tag_type,                                                   --新标签type
            t1.id as new_tag_id,                                                           --新标签id
            t1.is_display as is_display,                                                   --是否在app展示
            t1.is_online as is_online,                                                     --是否生效
            t1.homoionym as jianyi_word,                                                   --近义词
            t2.name as like_new_tag,                                                       --同义词
            t4.aggregate_type,                                                             --对应类型的枚举值
            (case when t4.aggregate_type='6' then t4.name else NULL end) as fangshi_1f,    --一级方式_name
            (case when t4.aggregate_type='2' then t4.name else NULL end) as fangshi_2d,    --二级方式_name
            (case when t4.aggregate_type='7' then t4.name else NULL end) as suqiu_1f,      --一级诉求_name
            (case when t4.aggregate_type='8' then t4.name else NULL end) as suqiu_2d,      --二级诉求_name
            (case when t4.aggregate_type='10' then t4.name else NULL end) as buwei_if,     --一级部位_name
            (case when t4.aggregate_type='3' then t4.name else NULL end) as buwei_2d,      --二级部位_name
            t7.old_tag_name as old_tag_name,                                               --老标签_name
            t7.old_tag_type as old_tag_type,                                               --老标签_type
            t5.old_tag_id as old_tag_id,                                                   --老标签_id
            (case when t4.aggregate_type='6' then t4.id else NULL end) as fangshi_1f_id,   --一级方式_id
            (case when t4.aggregate_type='2' then t4.id else NULL end) as fangshi_2d_id,   --二级方式_id
            (case when t4.aggregate_type='7' then t4.id else NULL end) as suqiu_1f_id,     --一级诉求_id
            (case when t4.aggregate_type='8' then t4.id else NULL end) as suqiu_2d_id,     --二级诉求_id
            (case when t4.aggregate_type='10' then t4.id else NULL end) as buwei_if_id,    --一级部位_id
            (case when t4.aggregate_type='3' then t4.id else NULL end) as buwei_2d_id      --二级部位_id
        from
            (select name,id,is_display,is_online,
                    case when tag_type in ('1') then '普通分类'
                         when tag_type in ('2') then '一级分类'
                         when tag_type in ('3') then '二级分类'
                        end as tag_type,
                    collect_list(t1.homoionym_detail) as homoionym
             from online.tl_hdfs_api_tag_3_0_view                                 --新标签id，近义词
    lateral view explode(json_split(homoionym)) t1 as homoionym_detail   --["\u8138\u578b\u77eb\u6b63"]转义   json_split
             where partition_date='$V_PARYMD'
             group by name,id,is_display,is_online,
                 case when tag_type in ('1') then '普通分类'
                 when tag_type in ('2') then '一级分类'
                 when tag_type in ('3') then '二级分类'
                 end
            ) t1
                left join
            (select name,tag_id from online.tl_hdfs_api_tag_aggregate_view  where partition_date='$V_PARYMD') t2      --新标签id，同义词
        on (t1.id=t2.tag_id)
            left join
            (select tag_attr_id as tag_ids,tag_id from online.tl_hdfs_api_tag_attr_tag_view where partition_date='$V_PARYMD') t3 --新标签id，属性ids
            on (t1.id=t3.tag_id)
            left join
            (select name,id,aggregate_type from online.tl_hdfs_api_tag_attr_view where partition_date='$V_PARYMD') t4   --属性id，属性分类
            on (t3.tag_ids=t4.id)
            left join
            (select old_tag_id,tag_id from online.tl_hdfs_api_tag_map_oldtag_view where partition_date='$V_PARYMD') t5
            on (t1.id=t5.tag_id)
            left join
            (select id,name as old_tag_name,
            case when tag_type in ('1') then '一级分类'
            when tag_type in ('2') then '二级分类'
            when tag_type in ('3') then '三级分类'
            when tag_type in ('4') then '城市'
            when tag_type in ('5') then '自由添加'
            when tag_type in ('6') then '医生'
            when tag_type in ('7') then '医院'
            when tag_type in ('8') then '频道'
            when tag_type in ('9') then '省份'
            when tag_type in ('10') then '国家'
            when tag_type in ('11') then '运营标签'
            end as old_tag_type
            from online.tl_hdfs_api_tag_view where partition_date='$V_PARYMD') t7
            on (t7.id=t5.old_tag_id)
    )t6
group by t6.new_tag_name,t6.new_tag_type,t6.new_tag_id,t6.is_display,t6.is_online