#!/bin/bash

function replace_date(){
  #old date
  old_start_date=`cat job.properties | grep start_date | awk -F"=" '{print $2}'`
  old_end_date=`cat job.properties | grep end_date | awk -F"=" '{print $2}'`
  #new date
  new_start_date=`date +"%Y-%m-%d"`"T00:00+0800"
  new_end_date=`date +"%Y-%m-%d"`"T12:00+0800"
  #replace
  sed -i "s/$old_start_date/$new_start_date/g" job.properties
  sed -i "s/$old_end_date/$new_end_date/g" job.properties
}

function start_job(){
  export OOZIE_URL=http://bj-gm-prod-cos-datacenter005:11000/oozie
  /opt/oozie-4.1.0-cdh5.16.1/bin/oozie job -config job.properties -run
  #echo "/opt/oozie-4.1.0-cdh5.16.1/bin/oozie job -config job.properties -run"
}

cd /opt/warehouse/workflow/tl_finance_financeaccount_view/
replace_date
start_job

cd ../tl_finance_financeexpand_view/
replace_date
start_job

cd ../tl_finance_financerevenue_view/
replace_date
start_job