package com.gmei.data.gateway.server.service.impl;

import com.gmei.data.gateway.server.dto.ExcelGenDto;
import com.gmei.data.gateway.server.service.SparksqlService;
import com.gmei.data.gateway.server.utils.DateUtils;
import com.gmei.data.gateway.server.utils.ProperUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.*;
import java.util.ArrayList;
import java.util.List;

/**
 * @ClassName SparksqlServiceImpl
 * @Author apple
 * @Date 2020/4/29
 * @Version V1.0
 **/
@Service
public class SparksqlServiceImpl implements SparksqlService {

    @Value("${sql.input.path}")
    private String sqlPath;
    @Value("${datasource.sparkSql.jdbcUrl}")
    private String sparkSqlJdbcUrl;
    @Value("${proper.file.path}")
    private String properFilePath;
    private static final Logger logger = LoggerFactory.getLogger(SparksqlServiceImpl.class);

    @Override
    public int executeSql(String name){
        File sqlDir = new File(sqlPath + name);
        File[] files = sqlDir.listFiles();
        for(File file : files){
            BufferedReader reader = null;
            StringBuffer sbf = new StringBuffer();
            try {
                reader = new BufferedReader(new FileReader(file));
                String tempStr;
                while ((tempStr = reader.readLine()) != null) {
                    sbf.append("\n").append(tempStr);
                }
                reader.close();
            } catch (IOException e) {
                e.printStackTrace();
                logger.error(e.getMessage());
                continue;
            } finally {
                if (reader != null) {
                    try {
                        reader.close();
                    } catch (IOException e1) {
                        e1.printStackTrace();
                        logger.error(e1.getMessage());
                        continue;
                    }
                }
            }
            String hql = sbf.toString();
            hql = hql.replaceAll("#partition_date", String.format("'%s'", DateUtils.getYesterdayDateSimpleStr()))
                    .replaceAll("#partition_day", String.format("'%s'", DateUtils.getYesterdayDateSimpleStr()));

            Connection conn = null;
            try{
                conn = DriverManager.getConnection(sparkSqlJdbcUrl,"bi","");
                Statement statement = conn.createStatement();
                int updateCount = statement.executeUpdate(hql);
                if(updateCount > 0){
                    logger.info("*** Execute By Sparksql success, hql: {}",hql);
                }else{
                    logger.warn("*** Execute By Sparksql finish, hql: {}",hql);
                }
            }catch (Exception e){
                e.printStackTrace();
                logger.error("*** Execute By Sparksql failed, error message: {}, hql: {}",e.getMessage(),hql);
                return 1;
            }
        }
        return 0;
    }

    @Override
    public ExcelGenDto getResultDto(String name){
        List<String> sheetNameList = new ArrayList<String>();
        List<List<String>> headersList = new ArrayList<List<String>>();
        List<List<List>> rowsList = new ArrayList<List<List>>();

        File sqlDir = new File(sqlPath + name);
        File[] files = sqlDir.listFiles();
        for(File file : files){
            String fileName = file.getName();
            String nameStr =fileName.replace(".sql","");

            String subject = "";
            String value = ProperUtils.getValue(properFilePath, nameStr);
            if(null != value){
                subject = value;
            }else{
                subject = nameStr;
            }
            sheetNameList.add(subject);

            List<String> headers = new ArrayList<String>();
            List<List> rows = new ArrayList<List>();

            BufferedReader reader = null;
            StringBuffer sbf = new StringBuffer();
            try {
                reader = new BufferedReader(new FileReader(file));
                String tempStr;
                while ((tempStr = reader.readLine()) != null) {
                    sbf.append("\n").append(tempStr);
                }
                reader.close();
            } catch (IOException e) {
                e.printStackTrace();
                logger.error(e.getMessage());
                continue;
            } finally {
                if (reader != null) {
                    try {
                        reader.close();
                    } catch (IOException e1) {
                        e1.printStackTrace();
                        logger.error(e1.getMessage());
                        continue;
                    }
                }
            }
            String hql = sbf.toString();
            hql = hql.replaceAll("#partition_date", String.format("'%s'", DateUtils.getYesterdayDateSimpleStr()))
                    .replaceAll("#partition_day", String.format("'%s'", DateUtils.getYesterdayDateSimpleStr()));

            Connection conn = null;
            try{
                conn = DriverManager.getConnection(sparkSqlJdbcUrl,"data","");
                Statement statement = conn.createStatement();
                ResultSet rs = statement.executeQuery(hql);
                ResultSetMetaData metaData = rs.getMetaData();
                int columnCount = metaData.getColumnCount();
                for(int i=1;i<= columnCount;i++){
                    String columnName = metaData.getColumnName(i);
                    headers.add(columnName);
                }
                while(rs.next()){
                    List<String> rowVals = new ArrayList<String>();
                    for(int i=1;i<= columnCount;i++){
                        rowVals.add(rs.getString(i));
                    }
                    rows.add(rowVals);
                }
            }catch (Exception e){
                e.printStackTrace();
                logger.error(e.getMessage());
                return null;
            }
            headersList.add(headers);
            rowsList.add(rows);
        }
        return new ExcelGenDto(sheetNameList,headersList,rowsList);
    }
}
